/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class ConfigureCommand
extends Command {
    private ConfigureCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"configure").requires(commandSourceStack -> commandSourceStack.hasPermission(0))).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> ConfigureCommand.configure((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"))));
    }

    private static int configure(CommandSourceStack context, EasyNPC<?> easyNPC) throws CommandSyntaxException {
        ServerPlayer serverPlayer = context.getPlayerOrException();
        ConfigurationData<?> configurationData = easyNPC.getEasyNPCConfigurationData();
        if (configurationData == null) {
            return ConfigureCommand.sendFailureMessage(context, "This EasyNPC does not support configuration!");
        }
        configurationData.openMainConfigurationMenu(serverPlayer);
        return 1;
    }
}

