/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.client;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record ExportClientPresetMessage(UUID uuid, String name, SkinModel skinModel, String fileName, CompoundTag data) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"preset_export_client");
    public static final CustomPacketPayload.Type<ExportClientPresetMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ExportClientPresetMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ExportClientPresetMessage::create);

    public static ExportClientPresetMessage create(FriendlyByteBuf buffer) {
        return new ExportClientPresetMessage(buffer.readUUID(), buffer.readUtf(), (SkinModel)buffer.readEnum(SkinModel.class), buffer.readUtf(), buffer.readNbt());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUtf(this.name);
        buffer.writeEnum((Enum)this.skinModel);
        buffer.writeUtf(this.fileName);
        buffer.writeNbt((Tag)this.data);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<ExportClientPresetMessage> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleClient() {
        if (this.uuid == null || this.uuid.toString().isEmpty()) {
            log.error("Invalid UUID {} for {}", (Object)this.uuid, (Object)this);
            return;
        }
        if (this.name == null || this.name.isEmpty()) {
            log.error("Invalid name {} for {}", (Object)this.name, (Object)this);
            return;
        }
        if (this.skinModel == null) {
            log.error("Invalid skin model for {}", (Object)this);
            return;
        }
        if (this.data == null) {
            log.error("Invalid data for {}", (Object)this);
            return;
        }
        if (this.fileName == null || this.fileName.isEmpty()) {
            log.warn("Export preset file name is empty for {}", (Object)this.uuid);
            return;
        }
        File presetFile = CustomPresetDataFiles.getPresetFile(this.skinModel, this.fileName);
        if (presetFile == null) {
            log.error("Failed to get preset file for {}", (Object)this);
            return;
        }
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {}", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile);
        try {
            NbtIo.writeCompressed((CompoundTag)this.data, (Path)presetFile.toPath());
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with UUID {} and skin {} to {}:", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile, (Object)exception);
        }
    }
}

