/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.spawner;

import de.markusbordihn.easynpc.menu.slots.PresetSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SpawnerMenu
extends AbstractContainerMenu {
    public static final int PLAYER_SLOT_START = 9;
    public static final int PLAYER_INVENTORY_SLOT_START = 9;
    public static final int presetItemSlotX = 42;
    public static final int presetItemSlotY = 169;
    protected static final int containerSize = 1;
    private final Container container;
    private final ContainerData data;

    public SpawnerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(9));
    }

    public SpawnerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, Container container, ContainerData containerData) {
        super(menuType, containerId);
        SpawnerMenu.checkContainerSize((Container)container, (int)1);
        SpawnerMenu.checkContainerDataCount((ContainerData)containerData, (int)9);
        this.container = container;
        this.data = containerData;
        this.addSlot(new PresetSlot(container, 0, 42, 169));
        int slotSize = 18;
        int slotSpacing = 8;
        int playerInventoryStartPositionX = 90;
        int playerInventoryStartPositionY = 153;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.addSlot(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + slotSpacing + inventoryColumn * slotSize, playerInventoryStartPositionY + inventoryRow * slotSize));
            }
        }
        int hotbarStartPositionX = 90;
        int hotbarStartPositionY = 213;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.addSlot(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + slotSpacing + playerInventorySlot * slotSize, hotbarStartPositionY));
        }
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return player != null && player.isAlive();
    }

    public BlockPos getSpawnerPosition() {
        return new BlockPos(this.data.get(0), this.data.get(1), this.data.get(2));
    }

    public int getSpawnRange() {
        return this.data.get(3);
    }

    public int getDespawnRange() {
        return this.data.get(8);
    }

    public int getRequiredPlayerRange() {
        return this.data.get(4);
    }

    public int getDelay() {
        return this.data.get(5);
    }

    public int getMaxNearbyEntities() {
        return this.data.get(6);
    }

    public int getSpawnCount() {
        return this.data.get(7);
    }

    public ItemStack getPresetItem() {
        return this.container.getItem(0);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = slot.getItem();
        if (itemStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return ItemStack.EMPTY;
    }
}

