/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetItem;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetEmptyItem
extends Item {
    public static final String NAME = "easy_npc_preset_empty";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public EasyNPCPresetEmptyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity instanceof Player) {
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.level();
        if (livingEntity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)livingEntity;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            Item item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"easy_npc_preset")).orElse(null);
            if (item == null) {
                log.error("Can't find item for storing preset {}", (Object)"easy_npc_preset");
                return InteractionResult.FAIL;
            }
            PresetData presetData = easyNPC.getEasyNPCPresetData();
            if (presetData == null) {
                log.error("Can't export preset data from {}", (Object)easyNPC);
                return InteractionResult.FAIL;
            }
            CompoundTag compoundTag = presetData.exportPresetData();
            EntityType entityType = livingEntity.getType();
            ResourceLocation entityTypeRegistryName = EntityType.getKey((EntityType)entityType);
            ItemStack presetItemStack = new ItemStack((ItemLike)item);
            EasyNPCPresetItem.savePreset(presetItemStack, entityTypeRegistryName, compoundTag);
            log.info("Captured NPC preset from {} with {} to {}", (Object)easyNPC, (Object)compoundTag, (Object)presetItemStack);
            if (!player.getInventory().add(presetItemStack)) {
                player.drop(presetItemStack, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset_empty"));
    }
}

