/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.gametest;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.gametest.GameTestHelpers;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenuHandler;
import java.util.UUID;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.Vec3;

public class ConfigurationScreenTestHelper {
    private ConfigurationScreenTestHelper() {
    }

    public static UUID mockOpenConfigurationScreen(ServerPlayer serverPlayer, ConfigurationType configurationType, EasyNPC<?> easyNPC, MenuType<? extends ConfigurationMenu> menuType) {
        MenuProvider menuProvider = ConfigurationMenuHandler.getMenuProvider(configurationType, easyNPC, menuType, ConfigurationMenuHandler.getScreenData(configurationType, easyNPC, serverPlayer, 0));
        UUID menuId = MenuManager.registerMenu(easyNPC.getUUID(), menuProvider, serverPlayer);
        MenuManager.openMenu(menuId, serverPlayer);
        return menuId;
    }

    public static void testConfigurationScreen(GameTestHelper helper, EntityType<? extends PathfinderMob> npcEntityType, ConfigurationType configurationType, MenuType<? extends ConfigurationMenu> menuType) {
        ServerPlayer serverPlayer = GameTestHelpers.mockServerPlayer(helper, new Vec3(1.0, 2.0, 1.0));
        EasyNPC<?> easyNPC = GameTestHelpers.mockEasyNPC(helper, npcEntityType, new Vec3(2.0, 2.0, 2.0));
        if (serverPlayer.hasContainerOpen()) {
            serverPlayer.closeContainer();
        }
        UUID dialogId = ConfigurationScreenTestHelper.mockOpenConfigurationScreen(serverPlayer, configurationType, easyNPC, menuType);
        GameTestHelpers.assertNotNull(helper, "DialogId is null!", dialogId);
        GameTestHelpers.assertTrue(helper, "Configuration Screen " + String.valueOf(menuType) + " is not open!", serverPlayer.containerMenu instanceof ConfigurationMenu);
        GameTestHelpers.assertEquals(helper, "Wrong Configuration type! Expected: " + String.valueOf(menuType) + " but got: " + String.valueOf(serverPlayer.containerMenu.getType()), menuType, serverPlayer.containerMenu.getType());
    }
}

