/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.display.DisplayAttributeSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface DisplayAttributeData<E extends PathfinderMob>
extends EasyNPC<E> {
    public static void registerSyncedDisplayAttributeData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Display Attribute Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.DISPLAY_ATTRIBUTE_SET));
    }

    default public DisplayAttributeSet getDisplayAttributeSet() {
        return (DisplayAttributeSet)this.getSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET);
    }

    default public void setDisplayAttributeSet(DisplayAttributeSet displayAttributeSet) {
        this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, displayAttributeSet);
    }

    default public void clearDisplayAttributeSet() {
        this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, new DisplayAttributeSet());
    }

    default public void updateDisplayAttributeSet() {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            this.clearDisplayAttributeSet();
            this.setDisplayAttributeSet(displayAttributeSet);
        }
    }

    default public boolean hasDisplayAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            return displayAttributeSet.hasDisplayAttribute(displayAttributeType);
        }
        return false;
    }

    default public boolean getDisplayBooleanAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            return displayAttributeSet.getBooleanValue(displayAttributeType);
        }
        return false;
    }

    default public int getDisplayIntAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            return displayAttributeSet.getIntValue(displayAttributeType);
        }
        return 0;
    }

    default public void defineSynchedDisplayAttributeData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, new DisplayAttributeSet());
    }

    default public void readAdditionalDisplayAttributeData(CompoundTag compoundTag) {
        if (compoundTag.contains("DisplayAttributeSet")) {
            DisplayAttributeSet displayAttributeSet = new DisplayAttributeSet(compoundTag);
            this.setDisplayAttributeSet(displayAttributeSet);
        }
    }

    default public void addAdditionalDisplayAttributeData(CompoundTag compoundTag) {
        DisplayAttributeSet displayAttributeSet = this.getDisplayAttributeSet();
        if (displayAttributeSet != null) {
            displayAttributeSet.save(compoundTag);
        }
    }
}

