/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.List;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ResetUniversalAngerTargetGoal<T extends EasyNPC<?>>
extends Goal {
    private final Mob mob;
    private final Level level;
    private final boolean alertOthersOfSameType;
    private int lastHurtByPlayerTimestamp;

    public ResetUniversalAngerTargetGoal(T easyNPC, boolean alertOthersOfSameType) {
        this.mob = easyNPC.getMob();
        this.level = easyNPC.getLevel();
        this.alertOthersOfSameType = alertOthersOfSameType;
    }

    public boolean canUse() {
        return this.level.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.wasHurtByPlayer();
    }

    private boolean wasHurtByPlayer() {
        return this.mob.getLastHurtByMob() != null && this.mob.getLastHurtByMob().getType() == EntityType.PLAYER && this.mob.getLastHurtByMobTimestamp() > this.lastHurtByPlayerTimestamp;
    }

    public void start() {
        this.lastHurtByPlayerTimestamp = this.mob.getLastHurtByMobTimestamp();
        ((NeutralMob)this.mob).forgetCurrentTargetAndRefreshUniversalAnger();
        if (this.alertOthersOfSameType) {
            this.getNearbyMobsOfSameType().stream().filter(nearMob -> nearMob != this.mob).map(NeutralMob.class::cast).forEach(NeutralMob::forgetCurrentTargetAndRefreshUniversalAnger);
        }
        super.start();
    }

    private List<? extends Mob> getNearbyMobsOfSameType() {
        double followRange = this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
        AABB nearbyRange = AABB.unitCubeFromLowerCorner((Vec3)this.mob.position()).inflate(followRange, 10.0, followRange);
        return this.mob.level().getEntitiesOfClass(this.mob.getClass(), nearbyRange, EntitySelector.NO_SPECTATORS);
    }
}

