/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class MoveBackToHomeGoal<T extends EasyNPC<?>>
extends Goal {
    private final float stopDistance;
    private final NavigationData<?> navigationData;
    private final PathfinderMob pathfinderMob;
    private final double speedModifier;
    private final int interval;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;

    public MoveBackToHomeGoal(T easyNPCEntity, double speedModifier, float stopDistance) {
        this(easyNPCEntity, speedModifier, stopDistance, 240);
    }

    public MoveBackToHomeGoal(T easyNPCEntity, double speedModifier, float stopDistance, int interval) {
        this.stopDistance = stopDistance;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.navigationData = easyNPCEntity.getEasyNPCNavigationData();
        this.pathfinderMob = easyNPCEntity.getPathfinderMob();
    }

    public boolean canUse() {
        if (this.pathfinderMob.isVehicle() || this.pathfinderMob.getRandom().nextInt(MoveBackToHomeGoal.reducedTickDelay((int)this.interval)) != 0 || this.pathfinderMob.isAggressive() && this.pathfinderMob.getTarget() != null || this.reachedHome()) {
            return false;
        }
        Vec3 vec3 = this.getPosition();
        if (vec3 == null) {
            return false;
        }
        BlockPos blockPos = this.navigationData.getHomePosition();
        this.wantedX = blockPos.getX();
        this.wantedY = blockPos.getY();
        this.wantedZ = blockPos.getZ();
        return true;
    }

    public boolean canContinueToUse() {
        return !this.pathfinderMob.getNavigation().isDone() && !this.pathfinderMob.isVehicle() && this.pathfinderMob.getTarget() == null;
    }

    public void start() {
        this.pathfinderMob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void stop() {
        this.pathfinderMob.getNavigation().stop();
        super.stop();
    }

    private Vec3 getPosition() {
        SectionPos homePosition;
        if (this.reachedHome()) {
            return null;
        }
        SectionPos currentPosition = SectionPos.of((BlockPos)this.pathfinderMob.blockPosition());
        return currentPosition != (homePosition = SectionPos.of((BlockPos)this.navigationData.getHomePosition())) ? DefaultRandomPos.getPosTowards((PathfinderMob)this.pathfinderMob, (int)10, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)homePosition), (double)1.5707963705062866) : null;
    }

    private boolean reachedHome() {
        if (this.navigationData == null) {
            return true;
        }
        if (!this.navigationData.hasHomePosition()) {
            return this.navigationData.getGroundPathNavigation().isDone();
        }
        if (this.pathfinderMob.blockPosition().equals((Object)this.navigationData.getHomePosition())) {
            return true;
        }
        BlockPos blockPos = this.pathfinderMob.blockPosition();
        Vec3i vec3i = new Vec3i(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        return this.navigationData.getHomePosition().closerThan(vec3i, (double)this.stopDistance);
    }
}

