/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface EasyNPCBaseModel<E extends PathfinderMob>
extends EasyNPCBase<E>,
ModelData<E>,
ScaleData<E> {
    public static void registerEasyNPCSyncedData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        ModelData.registerSyncedModelData(map, entityClass);
        ScaleData.registerSyncedScaleData(map, entityClass);
    }

    default public void defineEasyNPCBaseModelSyncedData(SynchedEntityData.Builder builder) {
        ScaleData scaleData;
        ModelData modelData = this.getEasyNPCModelData();
        if (modelData != null) {
            modelData.defineSynchedModelData(builder);
        }
        if ((scaleData = this.getEasyNPCScaleData()) != null) {
            scaleData.defineSynchedScaleData(builder);
        }
    }

    default public void addEasyNPCBaseModelAdditionalSaveData(CompoundTag compoundTag) {
        ScaleData scaleData;
        ModelData modelData = this.getEasyNPCModelData();
        if (modelData != null) {
            modelData.addAdditionalModelData(compoundTag);
        }
        if ((scaleData = this.getEasyNPCScaleData()) != null) {
            scaleData.addAdditionalScaleData(compoundTag);
        }
    }

    default public void readEasyNPCBaseModelAdditionalSaveData(CompoundTag compoundTag) {
        ScaleData scaleData;
        ModelData modelData = this.getEasyNPCModelData();
        if (modelData != null) {
            modelData.readAdditionalModelData(compoundTag);
        }
        if ((scaleData = this.getEasyNPCScaleData()) != null) {
            scaleData.readAdditionalScaleData(compoundTag);
        }
    }
}

