/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigData;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import de.markusbordihn.easynpc.entity.easynpc.data.CustomAttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.GuiData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.entity.easynpc.data.ServerData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import de.markusbordihn.easynpc.entity.easynpc.data.SpawnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttributeHandler;
import de.markusbordihn.easynpc.server.player.FakePlayer;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface EasyNPC<E extends PathfinderMob>
extends Npc {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final Random randomNumber = new Random();

    public int getNPCDataVersion();

    public void setNPCDataVersion(int var1);

    public FakePlayer getFakePlayer(ServerLevel var1, BlockPos var2);

    default public LookControl getLookControl() {
        LookControl lookControl;
        EasyNPC easyNPC = this;
        if (easyNPC instanceof Mob) {
            Mob mob = (Mob)easyNPC;
            lookControl = mob.getLookControl();
        } else {
            lookControl = null;
        }
        return lookControl;
    }

    default public ActionEventData<E> getEasyNPCActionEventData() {
        ActionEventData actionEventData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ActionEventData ? (actionEventData = (ActionEventData)easyNPC) : null;
    }

    default public AttackData<E> getEasyNPCAttackData() {
        AttackData attackData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof AttackData ? (attackData = (AttackData)easyNPC) : null;
    }

    default public AttributeData<E> getEasyNPCAttributeData() {
        AttributeData attributeData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof AttributeData ? (attributeData = (AttributeData)easyNPC) : null;
    }

    default public ConfigData<E> getEasyNPCConfigData() {
        ConfigData configData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ConfigData ? (configData = (ConfigData)easyNPC) : null;
    }

    default public ConfigurationData<E> getEasyNPCConfigurationData() {
        ConfigurationData configurationData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ConfigurationData ? (configurationData = (ConfigurationData)easyNPC) : null;
    }

    default public CustomAttributeData<E> getEasyNPCCustomAttributeData() {
        CustomAttributeData customAttributeData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof CustomAttributeData ? (customAttributeData = (CustomAttributeData)easyNPC) : null;
    }

    default public DialogData<E> getEasyNPCDialogData() {
        DialogData dialogData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof DialogData ? (dialogData = (DialogData)easyNPC) : null;
    }

    default public DisplayAttributeData<E> getEasyNPCDisplayAttributeData() {
        DisplayAttributeData displayAttributeData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof DisplayAttributeData ? (displayAttributeData = (DisplayAttributeData)easyNPC) : null;
    }

    default public GuiData<E> getEasyNPCGuiData() {
        GuiData guiData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof GuiData ? (guiData = (GuiData)easyNPC) : null;
    }

    default public SkinData<E> getEasyNPCSkinData() {
        SkinData skinData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof SkinData ? (skinData = (SkinData)easyNPC) : null;
    }

    default public ModelData<E> getEasyNPCModelData() {
        ModelData modelData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ModelData ? (modelData = (ModelData)easyNPC) : null;
    }

    default public NavigationData<E> getEasyNPCNavigationData() {
        NavigationData navigationData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof NavigationData ? (navigationData = (NavigationData)easyNPC) : null;
    }

    default public ObjectiveData<E> getEasyNPCObjectiveData() {
        ObjectiveData objectiveData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ObjectiveData ? (objectiveData = (ObjectiveData)easyNPC) : null;
    }

    default public OwnerData<E> getEasyNPCOwnerData() {
        OwnerData ownerData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof OwnerData ? (ownerData = (OwnerData)easyNPC) : null;
    }

    default public PresetData<E> getEasyNPCPresetData() {
        PresetData presetData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof PresetData ? (presetData = (PresetData)easyNPC) : null;
    }

    default public ProfessionData<E> getEasyNPCProfessionData() {
        ProfessionData professionData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ProfessionData ? (professionData = (ProfessionData)easyNPC) : null;
    }

    default public RenderData<E> getEasyNPCRenderData() {
        RenderData renderData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof RenderData ? (renderData = (RenderData)easyNPC) : null;
    }

    default public ScaleData<E> getEasyNPCScaleData() {
        ScaleData scaleData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ScaleData ? (scaleData = (ScaleData)easyNPC) : null;
    }

    default public ServerData<E> getEasyNPCServerData() {
        ServerData serverData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ServerData ? (serverData = (ServerData)easyNPC) : null;
    }

    default public SpawnerData<E> getEasyNPCSpawnerData() {
        SpawnerData spawnerData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof SpawnerData ? (spawnerData = (SpawnerData)easyNPC) : null;
    }

    default public TickerData<E> getEasyNPCTickerData() {
        TickerData tickerData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof TickerData ? (tickerData = (TickerData)easyNPC) : null;
    }

    default public TradingData<E> getEasyNPCTradingData() {
        TradingData tradingData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof TradingData ? (tradingData = (TradingData)easyNPC) : null;
    }

    default public SoundData<E> getEasyNPCSoundData() {
        SoundData soundData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof SoundData ? (soundData = (SoundData)easyNPC) : null;
    }

    default public VariantData<E> getEasyNPCVariantData() {
        VariantData variantData;
        EasyNPC easyNPC = this;
        return easyNPC instanceof VariantData ? (variantData = (VariantData)easyNPC) : null;
    }

    default public ActionHandler<E> getEasyNPCActionHandler() {
        ActionHandler actionHandler;
        EasyNPC easyNPC = this;
        return easyNPC instanceof ActionHandler ? (actionHandler = (ActionHandler)easyNPC) : null;
    }

    default public AttributeHandler<E> getEasyNPCAttributeHandler() {
        AttributeHandler attributeHandler;
        EasyNPC easyNPC = this;
        return easyNPC instanceof AttributeHandler ? (attributeHandler = (AttributeHandler)easyNPC) : null;
    }

    default public PathfinderMob getPathfinderMob() {
        PathfinderMob pathfinderMob;
        EasyNPC easyNPC = this;
        return easyNPC instanceof PathfinderMob ? (pathfinderMob = (PathfinderMob)easyNPC) : null;
    }

    default public Level getLevel() {
        Level level;
        EasyNPC easyNPC = this;
        if (easyNPC instanceof Mob) {
            Mob mob = (Mob)easyNPC;
            level = mob.level();
        } else {
            level = null;
        }
        return level;
    }

    default public ServerLevel getServerLevel() {
        ServerLevel serverLevel;
        Mob mob;
        EasyNPC easyNPC = this;
        return easyNPC instanceof Mob && (easyNPC = (mob = (Mob)easyNPC).level()) instanceof ServerLevel ? (serverLevel = (ServerLevel)easyNPC) : null;
    }

    default public boolean isClientSide() {
        return this.getLevel() != null && this.getLevel().isClientSide();
    }

    default public boolean isServerSide() {
        return !this.isClientSide();
    }

    default public LivingEntity getLivingEntity() {
        LivingEntity livingEntity;
        EasyNPC easyNPC = this;
        return easyNPC instanceof LivingEntity ? (livingEntity = (LivingEntity)easyNPC) : null;
    }

    default public Merchant getMerchant() {
        Merchant merchant;
        EasyNPC easyNPC = this;
        return easyNPC instanceof Merchant ? (merchant = (Merchant)easyNPC) : null;
    }

    default public RangedAttackMob getRangedAttackMob() {
        RangedAttackMob rangedAttackMob;
        EasyNPC easyNPC = this;
        return easyNPC instanceof RangedAttackMob ? (rangedAttackMob = (RangedAttackMob)easyNPC) : null;
    }

    default public ProfilerFiller getProfiler() {
        ProfilerFiller profilerFiller;
        EasyNPC easyNPC = this;
        if (easyNPC instanceof Mob) {
            Mob mob = (Mob)easyNPC;
            profilerFiller = mob.level().getProfiler();
        } else {
            profilerFiller = null;
        }
        return profilerFiller;
    }

    default public Entity getEntity() {
        Entity entity;
        EasyNPC easyNPC = this;
        return easyNPC instanceof Entity ? (entity = (Entity)easyNPC) : null;
    }

    default public Mob getMob() {
        Mob mob;
        EasyNPC easyNPC = this;
        return easyNPC instanceof Mob ? (mob = (Mob)easyNPC) : null;
    }

    default public UUID getUUID() {
        UUID uUID;
        EasyNPC easyNPC = this;
        if (easyNPC instanceof Entity) {
            Entity entity = (Entity)easyNPC;
            uUID = entity.getUUID();
        } else {
            uUID = null;
        }
        return uUID;
    }

    public GoalSelector getEntityGoalSelector();

    public GoalSelector getEntityTargetSelector();

    default public CrossbowAttackMob getCrossbowAttackMob() {
        CrossbowAttackMob crossbowAttackMob;
        EasyNPC easyNPC = this;
        return easyNPC instanceof CrossbowAttackMob ? (crossbowAttackMob = (CrossbowAttackMob)easyNPC) : null;
    }

    default public Component getEasyNPCTypeName() {
        return this.getEntity().getType().getDescription();
    }

    default public String getEntityTypeId() {
        if (this.getEntity() == null) {
            return null;
        }
        EntityType entitytype = this.getEntity().getType();
        ResourceLocation resourcelocation = EntityType.getKey((EntityType)entitytype);
        return entitytype.canSerialize() ? resourcelocation.toString() : null;
    }

    default public void handlePlayerJoin(ServerPlayer serverPlayer) {
        ObjectiveData<E> objectiveData = this.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onPlayerJoinUpdateObjective(serverPlayer);
        }
    }

    default public void handlePlayerLeave(ServerPlayer serverPlayer) {
        ObjectiveData<E> objectiveData = this.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onPlayerLeaveUpdateObjective(serverPlayer);
        }
    }

    default public void handleLivingEntityJoin(LivingEntity livingEntity) {
        ObjectiveData<E> objectiveData = this.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onLivingEntityJoinUpdateObjective(livingEntity);
        }
    }

    default public void handleLivingEntityLeave(LivingEntity livingEntity) {
        ObjectiveData<E> objectiveData = this.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onLivingEntityLeaveUpdateObjective(livingEntity);
        }
    }

    default public void handleEasyNPCJoin(EasyNPC<?> entity) {
        ObjectiveData<E> objectiveData = this.getEasyNPCObjectiveData();
        if (objectiveData != null && entity != null) {
            objectiveData.onEasyNPCJoinUpdateObjective(entity);
        }
    }

    default public void handleEasyNPCLeave(EasyNPC<?> entity) {
        ObjectiveData<E> objectiveData = this.getEasyNPCObjectiveData();
        if (objectiveData != null && entity != null) {
            objectiveData.onEasyNPCLeaveUpdateObjective(entity);
        }
    }

    default public void handleDieEvent(DamageSource damageSource) {
        ActionEventData<E> actionEventData;
        TradingData<E> tradingData = this.getEasyNPCTradingData();
        if (tradingData != null) {
            tradingData.stopTrading();
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_DEATH, this.getServerPlayerFromDamageSource(damageSource));
        }
    }

    default public void handleChangeDimensionEvent(DimensionTransition dimensionTransition) {
        TradingData<E> tradingData = this.getEasyNPCTradingData();
        if (tradingData != null) {
            tradingData.stopTrading();
        }
    }

    default public void handleHurtEvent(DamageSource damageSource, float damage) {
        ActionEventData<E> actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_HURT, this.getServerPlayerFromDamageSource(damageSource));
        }
    }

    default public ServerPlayer getServerPlayerFromDamageSource(DamageSource damageSource) {
        Projectile projectile;
        Entity entity = damageSource.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer;
        }
        Entity entity2 = damageSource.getDirectEntity();
        if (entity2 instanceof Projectile && (entity2 = (projectile = (Projectile)entity2).getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerOfProjectile = (ServerPlayer)entity2;
            return serverPlayerOfProjectile;
        }
        return null;
    }

    public <T> void defineSynchedEntityData(SynchedEntityData.Builder var1, SynchedDataIndex var2, T var3);

    public <T> void setSynchedEntityData(SynchedDataIndex var1, T var2);

    public <T> T getSynchedEntityData(SynchedDataIndex var1);
}

