/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.entity.LivingEntityEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

@EventBusSubscriber
public class LivingEntityEventHandler {
    private LivingEntityEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.isCanceled() && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntityEvents.handleLivingEntityJoinEvent(livingEntity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleEntityLeaveWorldEvent(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntityEvents.handleLivingEntityLeaveEvent(livingEntity);
        }
    }
}

