/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.scale;

import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class CustomScale {
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomScale> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CustomScale>(){

        public CustomScale decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new CustomScale(registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, CustomScale scale) {
            registryFriendlyByteBuf.writeFloat(scale.x);
            registryFriendlyByteBuf.writeFloat(scale.y);
            registryFriendlyByteBuf.writeFloat(scale.z);
        }
    };
    protected final float x;
    protected final float y;
    protected final float z;

    public CustomScale(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CustomScale(ListTag listTag) {
        this(listTag.getFloat(0), listTag.getFloat(1), listTag.getFloat(2));
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)this.x));
        listTag.add((Object)FloatTag.valueOf((float)this.y));
        listTag.add((Object)FloatTag.valueOf((float)this.z));
        return listTag;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public boolean hasChanged() {
        return this.hasChanged(1.0f, 1.0f, 1.0f);
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.x != x || this.y != y || this.z != z;
    }
}

