/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class AdvancedPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    protected RangeSliderButton headRotationSliderButton;
    protected RangeSliderButton bodyRotationSliderButton;
    protected RangeSliderButton armsRotationSliderButton;
    protected RangeSliderButton leftArmRotationSliderButton;
    protected RangeSliderButton rightArmRotationSliderButton;
    protected RangeSliderButton leftLegRotationSliderButton;
    protected RangeSliderButton rightLegRotationSliderButton;

    public AdvancedPoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private RangeSliderButton createVisibilityRotationSlider(int left, int top, ModelPart modelPart, String label) {
        RangeSliderButton sliderRotationButtonX = this.createRotationSlider(left, top, modelPart, label);
        boolean modelPartVisibility = this.modelData.isModelPartVisible(modelPart);
        this.addRenderableWidget((GuiEventListener)new Checkbox(sliderRotationButtonX.getX() + 3, top - sliderRotationButtonX.getHeight(), "", modelPartVisibility, checkbox -> NetworkMessageHandlerManager.getServerHandler().modelVisibilityChange(this.getEasyNPCUUID(), modelPart, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void init() {
        super.init();
        this.advancedPoseButton.active = false;
        int sliderLeftDefaultPos = this.contentLeftPos - 3;
        int sliderTopPos = this.contentTopPos + 56;
        int sliderLeftPos = sliderLeftDefaultPos;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 60;
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        boolean hasCrossedArms = variantData.hasVariantCrossedArms();
        if (this.modelData.hasHeadModelPart()) {
            this.headRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.HEAD, "head");
        }
        if (this.modelData.hasBodyModelPart()) {
            this.bodyRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.BODY, "body");
        }
        sliderTopPos += sliderTopSpace;
        if (hasCrossedArms || !this.modelData.hasLeftArmModelPart() && !this.modelData.hasRightArmModelPart() && this.modelData.hasArmsModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.armsRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.ARMS, "arms");
        }
        if (!hasCrossedArms && this.modelData.hasRightArmModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.rightArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_ARM, "right_arm");
        }
        if (!hasCrossedArms && this.modelData.hasLeftArmModelPart()) {
            this.leftArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_ARM, "left_arm");
        }
        sliderTopPos += sliderTopSpace;
        sliderLeftPos = sliderLeftDefaultPos;
        if (this.modelData.hasRightLegModelPart()) {
            this.rightLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_LEG, "right_leg");
        }
        if (this.modelData.hasLeftLegModelPart()) {
            this.leftLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_LEG, "left_leg");
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderCustomPoseEntityAvatar(guiGraphics, this.contentLeftPos + 157, this.contentTopPos + 165, 50, (float)(this.contentLeftPos + 150) - this.xMouse, (float)(this.contentTopPos + 80) - this.yMouse, this.getEasyNPC());
        if (this.modelData.hasHeadModelPart() && this.headRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "pose.head", this.headRotationSliderButton.getX() + 20, this.headRotationSliderButton.getY() - 12);
        }
        if (this.modelData.hasBodyModelPart() && this.bodyRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "pose.body", this.bodyRotationSliderButton.getX() + 20, this.bodyRotationSliderButton.getY() - 12);
        }
        if (this.modelData.hasLeftArmModelPart() && this.leftArmRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "pose.left_arm", this.leftArmRotationSliderButton.getX() + 20, this.leftArmRotationSliderButton.getY() - 12);
        } else if (this.modelData.hasArmsModelPart() && this.armsRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "pose.arms", this.armsRotationSliderButton.getX() + 20, this.armsRotationSliderButton.getY() - 12);
        }
        if (this.modelData.hasRightArmModelPart() && this.rightArmRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "pose.right_arm", this.rightArmRotationSliderButton.getX() + 20, this.rightArmRotationSliderButton.getY() - 12);
        }
        if (this.modelData.hasLeftLegModelPart() && this.leftLegRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "pose.left_leg", this.leftLegRotationSliderButton.getX() + 20, this.leftLegRotationSliderButton.getY() - 12);
        }
        if (this.modelData.hasRightLegModelPart() && this.rightLegRotationSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "pose.right_leg", this.rightLegRotationSliderButton.getX() + 20, this.rightLegRotationSliderButton.getY() - 12);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int backgroundTopPos = this.contentTopPos + 30;
        guiGraphics.fill(this.contentLeftPos + 109, backgroundTopPos, this.contentLeftPos + 206, this.contentTopPos + 178, -16777216);
        guiGraphics.fill(this.contentLeftPos + 110, backgroundTopPos + 1, this.contentLeftPos + 205, this.contentTopPos + 177, -5592406);
    }
}

