/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.standard.StandardSkeletonModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Skeleton;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class SkeletonModelRenderer
extends BaseHumanoidMobModelRenderer<Skeleton, Skeleton.Variant, StandardSkeletonModel<Skeleton>> {
    protected static final Map<Skeleton.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Skeleton.Variant.class), map -> {
        map.put(Skeleton.Variant.BOGGED, ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/bogged.png"));
        map.put(Skeleton.Variant.SKELETON, ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png"));
        map.put(Skeleton.Variant.STRAY, ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/stray.png"));
        map.put(Skeleton.Variant.WITHER_SKELETON, ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/wither_skeleton.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Skeleton.Variant.SKELETON);

    public <L extends RenderLayer<Skeleton, StandardSkeletonModel<Skeleton>>> SkeletonModelRenderer(EntityRendererProvider.Context context, Class<L> humanoidArmorLayerClass) {
        super(context, new StandardSkeletonModel(context.bakeLayer(ModelLayers.SKELETON)), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.addLayer((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.SKELETON_INNER_ARMOR, ModelLayers.SKELETON_OUTER_ARMOR, humanoidArmorLayerClass));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
    }

    @Override
    public void renderDefaultPose(Skeleton entity, StandardSkeletonModel<Skeleton> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-1.0, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                model.getHead().xRot = -0.7853982f;
                model.getHead().yRot = -0.7853982f;
                model.getHead().zRot = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.leftArmPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.rightArmPose = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.translate(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.leftArmPose = HumanoidModel.ArmPose.BLOCK;
                model.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.mulPose(Axis.YP.rotationDegrees(-35.0f));
                break;
            }
            default: {
                model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
                model.getHead().xRot = 0.0f;
                model.getHead().yRot = 0.0f;
                model.getHead().zRot = 0.0f;
            }
        }
    }
}

