/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.base.BasePlayerModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseLivingEntityModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Humanoid;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class HumanoidModelRenderer
extends BaseLivingEntityModelRenderer<Humanoid, Humanoid.Variant, BasePlayerModel<Humanoid>> {
    protected static final Map<Humanoid.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Humanoid.Variant.class), map -> {
        map.put(Humanoid.Variant.ALEX, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/alex.png"));
        map.put(Humanoid.Variant.ARI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/ari.png"));
        map.put(Humanoid.Variant.EFE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/efe.png"));
        map.put(Humanoid.Variant.KAI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/kai.png"));
        map.put(Humanoid.Variant.MAKENA, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/makena.png"));
        map.put(Humanoid.Variant.NOOR, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/noor.png"));
        map.put(Humanoid.Variant.STEVE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/steve.png"));
        map.put(Humanoid.Variant.SUNNY, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/sunny.png"));
        map.put(Humanoid.Variant.ZURI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/zuri.png"));
        map.put(Humanoid.Variant.JAYJASONBO, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/jayjasonbo.png"));
        map.put(Humanoid.Variant.PROFESSOR_01, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/professor_01.png"));
        map.put(Humanoid.Variant.SECURITY_01, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/security_01.png"));
        map.put(Humanoid.Variant.KNIGHT_01, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/knight_01.png"));
        map.put(Humanoid.Variant.KNIGHT_02, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/knight_02.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Humanoid.Variant.STEVE);

    public <L extends RenderLayer<Humanoid, BasePlayerModel<Humanoid>>> HumanoidModelRenderer(EntityRendererProvider.Context context, Class<L> humanoidArmorLayerClass) {
        super(context, new BasePlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.addLayer((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.PLAYER_INNER_ARMOR, ModelLayers.PLAYER_OUTER_ARMOR, humanoidArmorLayerClass));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
    }

    @Override
    public ResourceLocation getTextureLocation(Humanoid entity) {
        return this.getEntityPlayerTexture(entity);
    }

    @Override
    public void renderDefaultPose(Humanoid entity, BasePlayerModel<Humanoid> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-1.0, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                model.getHead().xRot = -0.7853982f;
                model.getHead().yRot = -0.7853982f;
                model.getHead().zRot = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.leftArmPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.rightArmPose = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.translate(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.leftArmPose = HumanoidModel.ArmPose.BLOCK;
                model.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.mulPose(Axis.YP.rotationDegrees(-35.0f));
                break;
            }
            default: {
                model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
                model.getHead().xRot = 0.0f;
                model.getHead().yRot = 0.0f;
                model.getHead().zRot = 0.0f;
            }
        }
    }
}

