/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.standard.StandardChickenModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseMobModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Chicken;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;

public class ChickenModelRenderer
extends BaseMobModelRenderer<Chicken, Chicken.Variant, StandardChickenModel<Chicken>> {
    protected static final Map<Chicken.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Chicken.Variant.class), map -> map.put(Chicken.Variant.WHITE, ResourceLocation.withDefaultNamespace((String)"textures/entity/chicken.png")));
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Chicken.Variant.WHITE);

    public ChickenModelRenderer(EntityRendererProvider.Context context) {
        super(context, new StandardChickenModel(context.bakeLayer(ModelLayers.CHICKEN)), 0.3f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    @Override
    public void renderDefaultPose(Chicken entity, StandardChickenModel<Chicken> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (entity.getPose()) {
            case DYING: {
                poseStack.translate(-0.5, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case SLEEPING: {
                poseStack.translate(-0.5, 0.5, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                break;
            }
        }
    }

    protected float getBob(Chicken entity, float delay) {
        float f = Mth.lerp((float)delay, (float)entity.getOFlap(), (float)entity.getFlap());
        float f1 = Mth.lerp((float)delay, (float)entity.getOFlapSpeed(), (float)entity.getFlapSpeed());
        return (Mth.sin((float)f) + 1.0f) * f1;
    }
}

