/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.standard.StandardCatModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseMobModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.CatCollarLayer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.HeldItemLayer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Cat;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;

public class CatModelRenderer
extends BaseMobModelRenderer<Cat, Cat.Variant, StandardCatModel<Cat>> {
    protected static final Map<Cat.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Cat.Variant.class), map -> {
        map.put(Cat.Variant.ALL_BLACK, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/all_black.png"));
        map.put(Cat.Variant.BLACK, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/black.png"));
        map.put(Cat.Variant.BRITISH_SHORTHAIR, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/british_shorthair.png"));
        map.put(Cat.Variant.CALICO, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/calico.png"));
        map.put(Cat.Variant.JELLIE, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/jellie.png"));
        map.put(Cat.Variant.OCELOT, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/ocelot.png"));
        map.put(Cat.Variant.PERSIAN, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/persian.png"));
        map.put(Cat.Variant.RAGDOLL, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/ragdoll.png"));
        map.put(Cat.Variant.RED, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/red.png"));
        map.put(Cat.Variant.SIAMESE, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/siamese.png"));
        map.put(Cat.Variant.TABBY, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/tabby.png"));
        map.put(Cat.Variant.WHITE, ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/white.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Cat.Variant.BLACK);

    public CatModelRenderer(EntityRendererProvider.Context context) {
        super(context, new StandardCatModel(context.bakeLayer(ModelLayers.CAT)), 0.4f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.addLayer(new CatCollarLayer(this, context.getModelSet()));
        this.addLayer(new HeldItemLayer(this, context.getItemInHandRenderer(), -0.05, 0.1, -0.5));
    }

    @Override
    public void renderDefaultPose(Cat entity, StandardCatModel<Cat> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-0.5, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                ((StandardCatModel)this.getModel()).getHead().xRot = -0.7853982f;
                ((StandardCatModel)this.getModel()).getHead().yRot = -0.7853982f;
                ((StandardCatModel)this.getModel()).getHead().zRot = -0.7853982f;
                break;
            }
            case SLEEPING: {
                poseStack.translate(-0.5, 0.5, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                break;
            }
            default: {
                ((StandardCatModel)this.getModel()).getHead().xRot = 0.0f;
                ((StandardCatModel)this.getModel()).getHead().yRot = 0.0f;
                ((StandardCatModel)this.getModel()).getHead().zRot = 0.0f;
            }
        }
    }
}

