/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BaseColorableAgeableListModel;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class StandardWolfModel<T extends Entity>
extends BaseColorableAgeableListModel<T>
implements HeadedModel {
    private final ModelPart upperBody;

    public StandardWolfModel(ModelPart modelPart) {
        super(modelPart);
        this.upperBody = this.defineModelPart(ModelPartType.UPPER_BODY, modelPart, "upper_body");
        ModelPart realHead = this.head.getChild("real_head");
        ModelPart realTail = this.tail.getChild("real_tail");
    }

    @Override
    public void resetModelParts() {
        super.resetModelParts();
        this.resetModelPart(ModelPartType.UPPER_BODY, this.upperBody);
    }

    @Override
    public boolean additionalModelAnimation(T entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Mob mob;
        this.tail.yRot = entity instanceof Mob && (mob = (Mob)entity).isAggressive() ? 0.0f : Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        return true;
    }

    @Override
    public boolean animateModelFrontLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    @Override
    public boolean animateModelHindLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.upperBody.setPos(-1.0f, 16.0f, -3.0f);
        this.upperBody.xRot = 1.2566371f;
        this.upperBody.yRot = 0.0f;
        this.body.setPos(0.0f, 18.0f, 0.0f);
        this.body.xRot = 0.7853982f;
        this.tail.setPos(-1.0f, 21.0f, 6.0f);
        this.rightHindLeg.setPos(-2.5f, 22.7f, 2.0f);
        this.rightHindLeg.xRot = 4.712389f;
        this.leftHindLeg.setPos(0.5f, 22.7f, 2.0f);
        this.leftHindLeg.xRot = 4.712389f;
        this.rightFrontLeg.xRot = 5.811947f;
        this.rightFrontLeg.setPos(-2.49f, 17.0f, -4.0f);
        this.leftFrontLeg.xRot = 5.811947f;
        this.leftFrontLeg.setPos(0.51f, 17.0f, -4.0f);
        return true;
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg, this.tail, this.upperBody);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

