/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model.geometry;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.model.NeoForgeBakedOpenModel;
import com.mrcrayfish.framework.client.model.OpenModelDeserializer;
import com.mrcrayfish.framework.util.Utils;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.ElementsModel;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import org.jetbrains.annotations.Nullable;

public class OpenModelGeometry
extends ElementsModel {
    private final BlockModel model;
    private final DataObject data;

    public OpenModelGeometry(BlockModel model, @Nullable DataObject data) {
        super(model.getElements());
        this.model = model;
        this.data = data;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return new NeoForgeBakedOpenModel(super.bake(context, baker, spriteGetter, modelState, overrides), this.data);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.model.resolveParents(modelGetter);
    }

    @EventBusSubscriber(modid="framework", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Loader
    implements IGeometryLoader<ElementsModel> {
        public OpenModelGeometry read(JsonObject object, JsonDeserializationContext context) throws JsonParseException {
            return new OpenModelGeometry(OpenModelDeserializer.INSTANCE.deserialize((JsonElement)object, (Type)((Object)BlockModel.class), context), DataObject.convert(object.get("data")));
        }

        @SubscribeEvent
        public static void onModelRegister(ModelEvent.RegisterGeometryLoaders event) {
            event.register(Utils.rl("open_model"), (IGeometryLoader)new Loader());
        }
    }
}

