/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.utils;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockMapEntityData {
    public static StreamCodec<ByteBuf, Map<BlockPos, BlockState>> BLOCK_MAP_CODEC = new StreamCodec<ByteBuf, Map<BlockPos, BlockState>>(){

        @NotNull
        public Map<BlockPos, BlockState> decode(ByteBuf byteBuf) {
            int size = VarInt.read((ByteBuf)byteBuf);
            HashMap map = Maps.newHashMapWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                map.put(FriendlyByteBuf.readBlockPos((ByteBuf)byteBuf), Block.stateById((int)VarInt.read((ByteBuf)byteBuf)));
            }
            return map;
        }

        public void encode(ByteBuf byteBuf, Map<BlockPos, BlockState> map) {
            VarInt.write((ByteBuf)byteBuf, (int)map.size());
            map.forEach((blockPos, blockState) -> {
                FriendlyByteBuf.writeBlockPos((ByteBuf)byteBuf, (BlockPos)blockPos);
                VarInt.write((ByteBuf)byteBuf, (int)Block.getId((BlockState)blockState));
            });
        }
    };
    public static final EntityDataSerializer<Map<BlockPos, BlockState>> BLOCK_MAP = EntityDataSerializer.forValueType(BLOCK_MAP_CODEC);
}

