/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees.mushroom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.TreeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BrownMushroomTree
implements TreeType {
    private static final BlockPos[] CAP_SCAN_OFFSET = new BlockPos[]{new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1)};

    @Override
    public boolean isTreeStem(BlockState blockState) {
        return blockState.is(Blocks.MUSHROOM_STEM);
    }

    @Override
    public TreeData gatherTreeData(BlockPos blockPos, Level level, Player player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.getMainHandItem())) {
            return null;
        }
        blockPos = blockPos.immutable();
        TreeData.Builder builder = TreeData.builder();
        Set<BlockPos> stemBlocks = this.gatherStemBlocks(level, blockPos);
        HashSet capBlocks = new HashSet();
        stemBlocks.forEach(stemPos -> capBlocks.addAll(this.gatherCapBlocks(level, stemPos.above())));
        if (capBlocks.isEmpty()) {
            return null;
        }
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        blocks.addAll(stemBlocks);
        blocks.addAll(capBlocks);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (BlockPos block : blocks) {
                BlockState blockState = level.getBlockState(block);
                List items = Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)block, null, (Entity)player, (ItemStack)player.getMainHandItem());
                drops.addAll(items);
            }
        }
        return builder.addBlocks(blocks).setToolDamage(blocks.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)blocks.size()).addDrops(drops).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)blocks.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).addAwardedStats(blocks.stream().map(logPos -> {
            BlockState blockState = level.getBlockState(logPos);
            return Stats.BLOCK_MINED.get((Object)blockState.getBlock());
        }).toList()).build();
    }

    private Set<BlockPos> gatherStemBlocks(Level level, BlockPos startPos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        Stack<BlockPos> toVisit = new Stack<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState currentState = level.getBlockState(current);
            if (!this.isTreeStem(currentState)) continue;
            blocks.add(current);
            BlockPos neighbor = current.above();
            if (visited.contains(neighbor)) continue;
            toVisit.add(neighbor);
        }
        return blocks;
    }

    private Set<BlockPos> gatherCapBlocks(Level level, BlockPos startPos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        LinkedList<BlockSearchNode> toVisit = new LinkedList<BlockSearchNode>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.add(new BlockSearchNode(startPos, 1));
        while (!toVisit.isEmpty()) {
            BlockSearchNode node = (BlockSearchNode)toVisit.poll();
            BlockPos current = node.position();
            if (visited.contains(current) || node.distance() > 6) continue;
            visited.add(current);
            BlockState currentState = level.getBlockState(current);
            if (!currentState.is(Blocks.BROWN_MUSHROOM_BLOCK)) continue;
            blocks.add(current);
            for (BlockPos offset : CAP_SCAN_OFFSET) {
                BlockPos neighbor = current.offset((Vec3i)offset);
                if (visited.contains(neighbor)) continue;
                toVisit.add(new BlockSearchNode(neighbor, node.distance() + 1));
            }
        }
        return blocks;
    }

    public TreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.mushroomTree;
    }

    private record BlockSearchNode(BlockPos position, int distance) {
    }
}

