/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Stack;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.GenericTreeConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.exceptions.TreeTooBigException;
import me.pandamods.fallingtrees.registry.SoundRegistry;
import me.pandamods.pandalib.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GenericTree
implements TreeType {
    @Override
    public boolean isTreeStem(BlockState blockState) {
        return this.getConfig().logFilter.isValid(blockState);
    }

    @Override
    public void onTreeTick(TreeEntity entity) {
        if (Services.GAME.isClient()) {
            ClientConfig clientConfig = FallingTreesConfig.getClientConfig();
            if (entity.tickCount == 1 && clientConfig.soundSettings.enabled) {
                entity.level().playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)SoundRegistry.TREE_FALL.get(), SoundSource.BLOCKS, clientConfig.soundSettings.startVolume, 1.0f, true);
            }
            if (entity.tickCount == (int)(clientConfig.animation.fallAnimLength * 20.0f) - 5 && clientConfig.soundSettings.enabled) {
                entity.level().playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)SoundRegistry.TREE_IMPACT.get(), SoundSource.BLOCKS, clientConfig.soundSettings.endVolume, 1.0f, true);
            }
        }
    }

    @Override
    public TreeData gatherTreeData(BlockPos blockPos, Level level, Player player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.getMainHandItem())) {
            return null;
        }
        blockPos = blockPos.immutable();
        TreeData.Builder builder = TreeData.builder();
        if (!this.isLogBlock(level.getBlockState(blockPos))) {
            return null;
        }
        Set<BlockPos> logs = this.gatherLogs(level, blockPos);
        if (logs.isEmpty()) {
            return null;
        }
        HashSet<BlockPos> leaves = new HashSet<BlockPos>();
        for (BlockPos logPos2 : logs) {
            leaves.addAll(this.gatherLeavesAroundLog(level, logPos2));
        }
        if (leaves.isEmpty()) {
            return null;
        }
        Set<BlockPos> adjacent = this.gatherAdjacentBlocks(level, logs, leaves);
        HashSet<BlockPos> allBlocks = new HashSet<BlockPos>(logs);
        allBlocks.addAll(leaves);
        allBlocks.addAll(adjacent);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos block : allBlocks) {
            BlockState blockState = level.getBlockState(block);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            List items = Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)block, null, (Entity)player, (ItemStack)player.getMainHandItem());
            drops.addAll(items);
        }
        return builder.addBlocks(allBlocks).setToolDamage(logs.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)logs.size()).addDrops(drops).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)logs.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).addAwardedStats(logs.stream().map(logPos -> {
            BlockState blockState = level.getBlockState(logPos);
            return Stats.BLOCK_MINED.get((Object)blockState.getBlock());
        }).toList()).build();
    }

    private Set<BlockPos> gatherLogs(Level level, BlockPos startPos) {
        HashSet<BlockPos> logs = new HashSet<BlockPos>();
        LinkedList<BlockPos> toVisit = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState currentState = level.getBlockState(current);
            if (!this.isLogBlock(currentState)) continue;
            logs.add(current);
            if (logs.size() > this.getConfig().algorithm.maxLogAmount) {
                throw new TreeTooBigException(current, level);
            }
            for (BlockPos offset : BlockPos.betweenClosed((int)-1, (int)0, (int)-1, (int)1, (int)1, (int)1)) {
                BlockPos neighbor = current.offset((Vec3i)offset);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return logs;
    }

    private Set<BlockPos> gatherLeavesAroundLog(Level level, BlockPos logPos) {
        HashSet<BlockPos> leaves = new HashSet<BlockPos>();
        LinkedList<BlockSearchNode> toVisit = new LinkedList<BlockSearchNode>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos neighbor = logPos.relative(direction);
            toVisit.add(new BlockSearchNode(neighbor, 1));
        }
        while (!toVisit.isEmpty()) {
            BlockSearchNode node = (BlockSearchNode)toVisit.poll();
            BlockPos current = node.position;
            BlockState currentState = level.getBlockState(current);
            OptionalInt optionalDistanceAt = LeavesBlock.getOptionalDistanceAt((BlockState)currentState);
            if (node.distance != optionalDistanceAt.orElse(0) || visited.contains(current) || node.distance > this.getConfig().algorithm.maxLeavesRadius) continue;
            visited.add(current);
            if (!this.isLeafBlock(currentState)) continue;
            leaves.add(current);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = current.relative(direction);
                if (visited.contains(nextPos)) continue;
                toVisit.add(new BlockSearchNode(nextPos, node.distance + 1));
            }
        }
        return leaves;
    }

    private Set<BlockPos> gatherAdjacentBlocks(Level level, Set<BlockPos> logs, Set<BlockPos> leaves) {
        HashSet<BlockPos> adjacentBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> allTreeBlocks = new HashSet<BlockPos>(logs);
        allTreeBlocks.addAll(leaves);
        for (BlockPos blockPos : allTreeBlocks) {
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = blockPos.relative(dir);
                BlockState neighborState = level.getBlockState(neighbor);
                if (neighborState.is(Blocks.VINE)) {
                    adjacentBlocks.addAll(this.gatherVines(level, neighbor));
                    continue;
                }
                if (neighborState.is(Blocks.BEE_NEST)) {
                    adjacentBlocks.add(neighbor);
                    continue;
                }
                if (!neighborState.is(Blocks.COCOA)) continue;
                adjacentBlocks.add(neighbor);
            }
        }
        return adjacentBlocks;
    }

    private Set<BlockPos> gatherVines(Level level, BlockPos startPos) {
        HashSet<BlockPos> vines = new HashSet<BlockPos>();
        Stack<BlockPos> toVisit = new Stack<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.push(startPos);
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState currentState = level.getBlockState(current);
            if (!currentState.is(Blocks.VINE)) continue;
            vines.add(current);
            BlockPos neighbor = current.below();
            if (visited.contains(neighbor)) continue;
            toVisit.push(neighbor);
        }
        return vines;
    }

    private boolean isLogBlock(BlockState blockState) {
        return this.getConfig().logFilter.isValid(blockState);
    }

    private boolean isLeafBlock(BlockState blockState) {
        if (this.getConfig().algorithm.shouldIgnorePersistentLeaves && blockState.hasProperty((Property)BlockStateProperties.PERSISTENT) && ((Boolean)blockState.getValue((Property)BlockStateProperties.PERSISTENT)).booleanValue()) {
            return false;
        }
        return this.getConfig().leavesFilter.isValid(blockState);
    }

    public GenericTreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.genericTree;
    }

    private record BlockSearchNode(BlockPos position, int distance) {
    }
}

