/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.TreeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ChorusTree
implements TreeType {
    private static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    @Override
    public boolean isTreeStem(BlockState blockState) {
        return ChorusTree.isPlant(blockState);
    }

    private static boolean isPlant(BlockState blockState) {
        return blockState.is(Blocks.CHORUS_PLANT);
    }

    private static boolean isFlower(BlockState blockState) {
        return blockState.is(Blocks.CHORUS_FLOWER);
    }

    @Override
    public TreeData gatherTreeData(BlockPos blockPos, Level level, Player player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.getMainHandItem())) {
            return null;
        }
        blockPos = blockPos.immutable();
        TreeData.Builder builder = TreeData.builder();
        Set<BlockPos> blockPosSet = this.gatherBlocks(level, blockPos, builder, player);
        return builder.addBlocks(blockPosSet).setToolDamage(blockPosSet.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)blockPosSet.size()).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)blockPosSet.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).build();
    }

    private Set<BlockPos> gatherBlocks(Level level, BlockPos startPos, TreeData.Builder builder, Player player) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> toVisit = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState currentState = level.getBlockState(current);
            if (ChorusTree.isFlower(currentState)) {
                blocks.add(current);
                continue;
            }
            if (!ChorusTree.isPlant(currentState)) continue;
            blocks.add(current);
            builder.addAwardedStat(Stats.BLOCK_MINED.get((Object)currentState.getBlock()));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                builder.addDrops(Block.getDrops((BlockState)currentState, (ServerLevel)serverLevel, (BlockPos)current, null, (Entity)player, (ItemStack)player.getMainHandItem()));
            }
            for (BlockPos neighbor : ChorusTree.gatherValidBlocksAround(level, current)) {
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return blocks;
    }

    private static List<BlockPos> gatherValidBlocksAround(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (Direction direction : HORIZONTAL_DIRECTIONS) {
            BlockState blockState;
            BlockPos neighborPos = blockPos.relative(direction);
            if (ChorusTree.isPlant(level.getBlockState(neighborPos.below())) || !ChorusTree.isPlant(blockState = level.getBlockState(neighborPos)) && !ChorusTree.isFlower(blockState)) continue;
            blocks.add(neighborPos);
        }
        BlockPos neighborPos = blockPos.above();
        BlockState blockState = level.getBlockState(neighborPos);
        if (ChorusTree.isPlant(blockState) || ChorusTree.isFlower(blockState)) {
            blocks.add(neighborPos);
        }
        return blocks;
    }

    public TreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.chorusTree;
    }
}

