/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.config.common.tree;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TreeConfig {
    public boolean enabled = true;
    public boolean requireTool = false;
    public Filter allowedToolFilter = new Filter(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());

    public static class Filter {
        public List<String> whitelistedTags;
        public List<String> whitelist;
        public List<String> blacklist;

        public Filter(List<String> whitelistedBlockTags, List<String> whitelistedBlocks, List<String> blacklistedBlocks) {
            this.whitelistedTags = whitelistedBlockTags;
            this.whitelist = whitelistedBlocks;
            this.blacklist = blacklistedBlocks;
        }

        public boolean isValid(BlockState blockState) {
            Block block = blockState.getBlock();
            ResourceLocation resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (this.blacklist.contains(resourceLocation.toString())) {
                return false;
            }
            return blockState.getTags().anyMatch(blockTagKey -> this.whitelistedTags.contains(blockTagKey.location().toString())) || this.whitelist.contains(resourceLocation.toString());
        }

        public boolean isValid(ItemStack itemStack) {
            Item item = itemStack.getItem();
            ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)item);
            if (this.blacklist.contains(resourceLocation.toString())) {
                return false;
            }
            return itemStack.getTags().anyMatch(blockTagKey -> this.whitelistedTags.contains(blockTagKey.location().toString())) || this.whitelist.contains(resourceLocation.toString());
        }
    }
}

