/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TreeRenderer
extends EntityRenderer<TreeEntity> {
    public TreeRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ClientConfig getConfig() {
        return FallingTreesConfig.getClientConfig((Player)Minecraft.getInstance().player);
    }

    public void render(TreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        TreeType tree = entity.treeType;
        if (tree == null) {
            return;
        }
        poseStack.pushPose();
        Map<BlockPos, BlockState> blocks = entity.getBlocks();
        float fallAnimLength = this.getConfig().animation.fallAnimLength;
        float bounceHeight = this.getConfig().animation.bounceAngleHeight;
        float bounceAnimLength = this.getConfig().animation.bounceAnimLength;
        float time = (float)((double)entity.getLifetime(partialTick) * 1.5707963267948966 / (double)fallAnimLength);
        float fallAnim = this.bumpCos(time) * 90.0f;
        float bounceAnim = this.bumpSin((float)(((double)time - 1.5707963267948966) / (double)(bounceAnimLength / (fallAnimLength * 2.0f)))) * bounceHeight;
        float animation = fallAnim + bounceAnim - 90.0f;
        Direction direction = entity.getDirection().getOpposite();
        float distance = this.getDistance(tree, blocks, direction.getOpposite());
        Vector3f pivot = new Vector3f(0.0f, 0.0f, 0.5f + distance);
        pivot.rotateY(Math.toRadians((float)(-direction.toYRot())));
        poseStack.translate(-pivot.x, 0.0f, -pivot.z);
        Vector3f vector = new Vector3f(Math.toRadians((float)animation), 0.0f, 0.0f);
        vector.rotateY(Math.toRadians((float)(-direction.toYRot())));
        Quaternionf quaternion = new Quaternionf().identity().rotateX(vector.x).rotateZ(vector.z);
        poseStack.mulPose(quaternion);
        Level level = entity.level();
        poseStack.translate(pivot.x, 0.0f, pivot.z);
        poseStack.translate(-0.5, 0.0, -0.5);
        blocks.forEach((blockPos, blockState) -> {
            poseStack.pushPose();
            poseStack.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
            blockPos = blockPos.offset((Vec3i)entity.getOriginPos());
            RenderUtils.renderSingleBlock(poseStack, blockState, blockPos, (BlockAndTintGetter)level, bufferSource, packedLight);
            poseStack.popPose();
        });
        poseStack.popPose();
    }

    private float getDistance(TreeType tree, Map<BlockPos, BlockState> blocks, Direction direction) {
        float distance = 0.0f;
        BlockPos currentPos = new BlockPos(0, 0, 0);
        BlockPos next = currentPos.relative(direction);
        while (blocks.containsKey(next) && tree.isTreeStem(blocks.get(next))) {
            currentPos = next;
            next = currentPos.relative(direction);
            distance += 1.0f;
        }
        BlockState blockState = blocks.get(currentPos);
        if (blockState.hasOffsetFunction()) {
            return distance - 0.5f;
        }
        VoxelShape shape = blockState.getCollisionShape((BlockGetter)Minecraft.getInstance().level, currentPos);
        if (shape.isEmpty()) {
            shape = blockState.getShape((BlockGetter)Minecraft.getInstance().level, currentPos);
        }
        if (!shape.isEmpty()) {
            AABB bounds = shape.bounds();
            switch (direction) {
                case WEST: {
                    distance -= (float)bounds.minX;
                    break;
                }
                case EAST: {
                    distance -= (float)(1.0 - bounds.maxX);
                    break;
                }
                case SOUTH: {
                    distance -= (float)bounds.minZ;
                    break;
                }
                case NORTH: {
                    distance -= (float)(1.0 - bounds.maxZ);
                }
            }
        } else {
            distance -= 1.0f;
        }
        return distance;
    }

    private float bumpCos(float time) {
        return (float)Math.max((double)0.0, (double)Math.cos((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    private float bumpSin(float time) {
        return (float)Math.max((double)0.0, (double)Math.sin((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    public ResourceLocation getTextureLocation(TreeEntity entity) {
        return null;
    }
}

