/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.client.CustomRenderTypes;
import com.tom.storagemod.client.ViveCraftHelper;
import com.tom.storagemod.components.ConfiguratorComponent;
import com.tom.storagemod.item.WirelessTerminalItem;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.ComponentJoiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClientUtil {
    private static Component[] tooltipExt = new Component[0];

    public static void tooltip(String key, List<Component> tooltip, Object ... args) {
        ClientUtil.tooltip(key, true, tooltip, args);
    }

    public static void tooltip(String key, boolean addShift, List<Component> tooltip, Object ... args) {
        if (Screen.hasShiftDown()) {
            String[] sp = I18n.get((String)("tooltip.toms_storage." + key), (Object[])args).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.add((Component)Component.literal((String)sp[i]));
            }
        } else if (addShift) {
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.hold_shift_for_info").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    public static void setTooltip(Component ... string) {
        tooltipExt = string;
    }

    public static void collectExtraTooltips(ItemStack stack, List<Component> toolip) {
        Collections.addAll(toolip, tooltipExt);
    }

    public static void drawTerminalOutline(PoseStack ps) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (!WirelessTerminalItem.isPlayerHolding((Player)player)) {
            return;
        }
        BlockHitResult lookingAt = ClientUtil.rayTrace((Player)player, Config.get().wirelessRange, true);
        BlockState state = mc.level.getBlockState(lookingAt.getBlockPos());
        if (state.is(StorageTags.REMOTE_ACTIVATE)) {
            BlockPos pos = lookingAt.getBlockPos();
            Vec3 renderPos = mc.gameRenderer.getMainCamera().getPosition();
            VertexConsumer buf = mc.renderBuffers().bufferSource().getBuffer(RenderType.lines());
            ClientUtil.drawShape(ps, buf, state.getOcclusionShape((BlockGetter)player.level(), pos), (double)pos.getX() - renderPos.x, (double)pos.getY() - renderPos.y, (double)pos.getZ() - renderPos.z, 1.0f, 1.0f, 1.0f, 0.4f);
            mc.renderBuffers().bufferSource().endBatch(RenderType.lines());
        }
    }

    private static BlockHitResult rayTrace(Player player, double maxDist, boolean hitFluids) {
        HitResult vr;
        if (Platform.vivecraft && (vr = ViveCraftHelper.rayTraceVR(maxDist, hitFluids)) != null) {
            return (BlockHitResult)vr;
        }
        return (BlockHitResult)player.pick(maxDist, 0.0f, hitFluids);
    }

    public static void drawConfiguratorOutline(PoseStack ps) {
        HitResult x2;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack is = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!is.is((Item)Content.invConfig.get())) {
            is = player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (!is.is((Item)Content.invConfig.get())) {
            return;
        }
        ConfiguratorComponent c = (ConfiguratorComponent)is.get(Content.configuratorComponent.get());
        if (!c.selecting() && !c.showInvBox()) {
            return;
        }
        Vec3 renderPos = mc.gameRenderer.getMainCamera().getPosition();
        VertexConsumer buf = mc.renderBuffers().bufferSource().getBuffer(RenderType.lines());
        for (BlockPos pos : c.selection()) {
            double x2 = (double)pos.getX() - renderPos.x;
            double y = (double)pos.getY() - renderPos.y;
            double z = (double)pos.getZ() - renderPos.z;
            LevelRenderer.renderLineBox((PoseStack)ps, (VertexConsumer)buf, (double)x2, (double)y, (double)z, (double)(x2 + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }
        VertexConsumer bufNd = mc.renderBuffers().bufferSource().getBuffer(CustomRenderTypes.linesNoDepth());
        if (c.massSelect() && (x2 = mc.hitResult) instanceof BlockHitResult) {
            BlockHitResult hr = (BlockHitResult)x2;
            int sx = c.boxStart().getX();
            int sy = c.boxStart().getY();
            int sz = c.boxStart().getZ();
            AABB bb = AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(sx, sy, sz), (BlockPos)hr.getBlockPos());
            bb = bb.move(-renderPos.x, -renderPos.y, -renderPos.z);
            LevelRenderer.renderLineBox((PoseStack)ps, (VertexConsumer)bufNd, (AABB)bb, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.4f);
        }
        if (!c.isBound()) {
            return;
        }
        double x3 = (double)c.bound().getX() - renderPos.x;
        double y = (double)c.bound().getY() - renderPos.y;
        double z = (double)c.bound().getZ() - renderPos.z;
        LevelRenderer.renderLineBox((PoseStack)ps, (VertexConsumer)bufNd, (double)x3, (double)y, (double)z, (double)(x3 + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        mc.renderBuffers().bufferSource().endBatch();
    }

    private static void drawShape(PoseStack matrices, VertexConsumer vertexConsumer, VoxelShape voxelShape, double d, double e, double f, float g, float h, float i, float j) {
        PoseStack.Pose entry = matrices.last();
        voxelShape.forAllEdges((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.sqrt((float)(q * q + r * r + s * s));
            vertexConsumer.addVertex(entry.pose(), (float)(k + d), (float)(l + e), (float)(m + f)).setColor(g, h, i, j).setNormal(entry, q /= t, r /= t, s /= t);
            vertexConsumer.addVertex(entry.pose(), (float)(n + d), (float)(o + e), (float)(p + f)).setColor(g, h, i, j).setNormal(entry, q, r, s);
        });
    }

    public static Component multilineTooltip(String text, Object ... objects) {
        return Arrays.stream(I18n.get((String)text, (Object[])objects).split("\\\\")).map(Component::literal).collect(ComponentJoiner.joining((Component)Component.empty(), (Component)Component.literal((String)"\n")));
    }
}

