/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.AbstractInventoryHopperBlock;
import com.tom.storagemod.block.entity.AbstractInventoryHopperBlockEntity;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventorySlot;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.util.BlockFaceReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BasicInventoryHopperBlockEntity
extends AbstractInventoryHopperBlockEntity {
    private ItemStack filter = ItemStack.EMPTY;
    private int cooldown;
    private long topChange;
    private long bottomChange;
    public int waiting = 0;
    private ItemPredicate filterPred;
    private InventorySlot topSlot;

    public BasicInventoryHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.basicInvHopperBE.get(), pos, state);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        ItemStack is = this.getFilter();
        if (!is.isEmpty()) {
            compound.put("Filter", is.save(provider, (Tag)new CompoundTag()));
        }
    }

    public void loadAdditional(CompoundTag nbtIn, HolderLookup.Provider provider) {
        super.loadAdditional(nbtIn, provider);
        this.filter = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtIn.getCompound("Filter"));
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
        if (this.filter.isEmpty()) {
            this.filterPred = null;
        } else {
            Item item = this.filter.getItem();
            if (item instanceof IItemFilter) {
                IItemFilter i = (IItemFilter)item;
                this.filterPred = i.createFilter(BlockFaceReference.touching(this.level, this.worldPosition, (Direction)this.getBlockState().getValue((Property)AbstractInventoryHopperBlock.FACING)), filter);
            } else {
                this.filterPred = s -> ItemStack.isSameItemSameComponents((ItemStack)s.getStack(), (ItemStack)filter);
            }
        }
        this.waiting = 0;
        this.setChanged();
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    @Override
    public void updateServer() {
        boolean topWasNull;
        boolean hasFilter;
        if (!this.filter.isEmpty() && this.filterPred == null) {
            this.setFilter(this.filter);
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        Direction facing = (Direction)state.getValue((Property)AbstractInventoryHopperBlock.FACING);
        IInventoryAccess top = this.topCache.getAccess(this.level, this.worldPosition.relative(facing.getOpposite()));
        IInventoryAccess bottom = this.bottomCache.getAccess(this.level, this.worldPosition.relative(facing));
        boolean topNet = this.topCache.isNetwork();
        if (!this.topCache.isValid() || !this.bottomCache.isValid()) {
            return;
        }
        if (!topNet && !this.bottomCache.isNetwork()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        boolean bl = hasFilter = this.filterPred != null;
        if (topNet && !hasFilter) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        IInventoryAccess.IInventoryChangeTracker tt = top.tracker();
        long t = tt.getChangeTracker(this.level);
        if (this.topChange != t) {
            this.topChange = t;
            this.waiting = 0;
            this.topSlot = null;
        } else {
            this.cooldown = 4;
        }
        if (this.waiting == 1) {
            return;
        }
        IInventoryAccess.IInventoryChangeTracker bt = bottom.tracker();
        long b = bt.getChangeTracker(this.level);
        if (this.bottomChange != b) {
            this.bottomChange = b;
            this.waiting = 0;
        } else {
            this.cooldown = 4;
        }
        if (this.waiting == 2) {
            return;
        }
        boolean bl2 = topWasNull = this.topSlot == null;
        if (hasFilter) {
            this.filterPred.updateState();
        }
        if (this.topSlot == null || this.waiting == 3) {
            this.topSlot = tt.findSlotAfter(this.topSlot, hasFilter ? this.filterPred : s -> true, false, true);
        }
        if (this.topSlot == null) {
            if (topWasNull) {
                this.waiting = 1;
                this.cooldown = 10;
            } else {
                this.cooldown = 4;
            }
            return;
        }
        ItemStack is = this.topSlot.getStack();
        if (is.isEmpty()) {
            this.waiting = 3;
            this.cooldown = 1;
            return;
        }
        StoredItemStack st = new StoredItemStack(is);
        if (hasFilter && !this.filterPred.test(st)) {
            this.waiting = 3;
            this.cooldown = 1;
            return;
        }
        InventorySlot bottomSlot = bt.findSlotDest(st);
        if (bottomSlot == null) {
            this.waiting = 3;
            this.cooldown = 10;
            return;
        }
        if (this.topSlot.transferTo(1, bottomSlot)) {
            this.cooldown = 10;
        } else {
            this.waiting = 3;
            this.cooldown = 10;
        }
    }
}

