/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.mojang.serialization.MapCodec;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.IPaintable;
import com.tom.storagemod.block.InventoryCableBlock;
import com.tom.storagemod.block.NeoForgeBlock;
import com.tom.storagemod.block.entity.PaintedBlockEntity;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.util.BlockFace;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class FramedInventoryCableBlock
extends BaseEntityBlock
implements IInventoryCable,
IPaintable,
NeoForgeBlock {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final MapCodec<FramedInventoryCableBlock> CODEC = ChestBlock.simpleCodec(properties -> new FramedInventoryCableBlock());

    public FramedInventoryCableBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.paintable"));
        ClientUtil.tooltip("inventory_cable", tooltip, new Object[0]);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    @Override
    public List<BlockFace> nextScan(Level world, BlockState state, BlockPos pos) {
        ArrayList<BlockFace> next = new ArrayList<BlockFace>();
        for (Direction d : Direction.values()) {
            if (!((Boolean)state.getValue((Property)InventoryCableBlock.DIR_TO_PROPERTY[d.ordinal()])).booleanValue()) continue;
            next.add(new BlockFace(pos.relative(d), d.getOpposite()));
        }
        return next;
    }

    @Override
    public boolean isFunctionalNode() {
        return false;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(IInventoryCable.canConnect(facingState, facing)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.withConnectionProperties((LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState withConnectionProperties(LevelAccessor blockView_1, BlockPos blockPos_1) {
        BlockState block_1 = blockView_1.getBlockState(blockPos_1.below());
        BlockState block_2 = blockView_1.getBlockState(blockPos_1.above());
        BlockState block_3 = blockView_1.getBlockState(blockPos_1.north());
        BlockState block_4 = blockView_1.getBlockState(blockPos_1.east());
        BlockState block_5 = blockView_1.getBlockState(blockPos_1.south());
        BlockState block_6 = blockView_1.getBlockState(blockPos_1.west());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(IInventoryCable.canConnect(block_1, Direction.DOWN)))).setValue((Property)UP, (Comparable)Boolean.valueOf(IInventoryCable.canConnect(block_2, Direction.UP)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(IInventoryCable.canConnect(block_3, Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(IInventoryCable.canConnect(block_4, Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(IInventoryCable.canConnect(block_5, Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(IInventoryCable.canConnect(block_6, Direction.WEST)));
    }

    public BlockState rotate(BlockState blockState_1, Rotation blockRotation_1) {
        switch (blockRotation_1) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)));
            }
        }
        return blockState_1;
    }

    public BlockState mirror(BlockState blockState_1, Mirror blockMirror_1) {
        switch (blockMirror_1) {
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)));
            }
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState_1.setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)));
            }
        }
        return super.mirror(blockState_1, blockMirror_1);
    }

    @Override
    public boolean paint(Level world, BlockPos pos, BlockState to) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te != null && te instanceof PaintedBlockEntity) {
            return ((PaintedBlockEntity)te).setPaintedBlockState(to);
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PaintedBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void destroy(LevelAccessor p_49860_, BlockPos p_49861_, BlockState p_49862_) {
        if (p_49860_ instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)p_49860_;
            InventoryCableNetwork.getNetwork((Level)l).markNodeInvalid(p_49861_);
        }
    }

    public void neighborChanged(BlockState p_60509_, Level p_60510_, BlockPos p_60511_, Block p_60512_, BlockPos p_60513_, boolean p_60514_) {
        super.neighborChanged(p_60509_, p_60510_, p_60511_, p_60512_, p_60513_, p_60514_);
        if (!p_60510_.isClientSide) {
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork(p_60510_);
            n.markNodeInvalid(p_60511_);
            n.markNodeInvalid(p_60513_);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork((Level)l);
            n.markNodeInvalid(pos);
            n.markNodeInvalid(neighbor);
        }
    }
}

