/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.objects.WindowBarred;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Window
extends WindowBarred {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ExtendablePart> PART = EnumProperty.create((String)"part", ExtendablePart.class);
    protected static final VoxelShape EE = Window.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = Window.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public Window(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)ExtendablePart.BASE))).setValue((Property)WINDOWSTATE, (Comparable)((Object)WindowBarred.WindowState.CLOSED)));
    }

    protected BlockState WindowState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean below;
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean bl = below = level.getBlockState(pos.below()).getBlock() == this;
        if (above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MIDDLE));
        }
        if (!above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.ABOVE));
        }
        if (above && !below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BELOW));
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BASE));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            this.WindowState(state, (LevelAccessor)level, pos);
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.WindowState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos()).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.WindowState(state, level, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, WINDOWSTATE});
    }

    public static enum ExtendablePart implements StringRepresentable
    {
        BASE("base"),
        ABOVE("above"),
        MIDDLE("middle"),
        BELOW("below");

        private final String name;

        private ExtendablePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

