/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.Deque;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.common.NeoForge;

public enum PlayerRenderHandler {
    INSTANCE;

    public static boolean Disabled;
    private final LoadingCache<Object, Deque<Runnable>> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Object, Deque<Runnable>>(this){

        public Deque<Runnable> load(Object key) throws Exception {
            return new ArrayDeque<Runnable>();
        }
    });

    private void handleLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        Disabled = false;
    }

    private void handlePreRenderPlayer_High(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        Deque queue = (Deque)this.cache.getUnchecked((Object)player);
        this.restoreItems(queue);
        NonNullList armor = player.getInventory().armor;
        int i = 0;
        while (i < armor.size()) {
            int slot = i++;
            ItemStack stack = (ItemStack)armor.get(slot);
            queue.add(() -> armor.set(slot, (Object)stack));
        }
        if (Disabled) {
            return;
        }
        InventoryCosArmor invCosArmor = ModObjects.invMan.getCosArmorInventoryClient(player.getUUID());
        for (int i2 = 0; i2 < armor.size(); ++i2) {
            if (invCosArmor.isSkinArmor(i2)) {
                armor.set(i2, (Object)ItemStack.EMPTY);
                continue;
            }
            ItemStack stack = invCosArmor.getStackInSlot(i2);
            if (stack.isEmpty()) continue;
            armor.set(i2, (Object)stack);
        }
    }

    private void handlePostRenderPlayer_Low(RenderPlayerEvent.Post event) {
        this.restoreItems((Deque)this.cache.getUnchecked((Object)event.getEntity()));
    }

    private void handlePreRenderPlayer_LowestCanceled(RenderPlayerEvent.Pre event) {
        if (!event.isCanceled()) {
            return;
        }
        this.restoreItems((Deque)this.cache.getUnchecked((Object)event.getEntity()));
    }

    private void handleRenderHand_High(RenderHandEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        Deque queue = (Deque)this.cache.getUnchecked((Object)player);
        this.restoreItems(queue);
        NonNullList armor = player.getInventory().armor;
        int i = 0;
        while (i < armor.size()) {
            int slot = i++;
            ItemStack stack = (ItemStack)armor.get(slot);
            queue.add(() -> armor.set(slot, (Object)stack));
        }
        if (Disabled) {
            return;
        }
        InventoryCosArmor invCosArmor = ModObjects.invMan.getCosArmorInventoryClient(player.getUUID());
        for (int i2 = 0; i2 < armor.size(); ++i2) {
            if (invCosArmor.isSkinArmor(i2)) {
                armor.set(i2, (Object)ItemStack.EMPTY);
                continue;
            }
            ItemStack stack = invCosArmor.getStackInSlot(i2);
            if (stack.isEmpty()) continue;
            armor.set(i2, (Object)stack);
        }
    }

    private void handleRenderHand_LowestCanceled(RenderHandEvent event) {
        this.restoreItems((Deque)this.cache.getUnchecked((Object)Minecraft.getInstance().player));
    }

    private void handleRenderArm_High(RenderArmEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        Deque queue = (Deque)this.cache.getUnchecked((Object)player);
        this.restoreItems(queue);
        NonNullList armor = player.getInventory().armor;
        int i = 0;
        while (i < armor.size()) {
            int slot = i++;
            ItemStack stack = (ItemStack)armor.get(slot);
            queue.add(() -> armor.set(slot, (Object)stack));
        }
        if (Disabled) {
            return;
        }
        InventoryCosArmor invCosArmor = ModObjects.invMan.getCosArmorInventoryClient(player.getUUID());
        for (int i2 = 0; i2 < armor.size(); ++i2) {
            if (invCosArmor.isSkinArmor(i2)) {
                armor.set(i2, (Object)ItemStack.EMPTY);
                continue;
            }
            ItemStack stack = invCosArmor.getStackInSlot(i2);
            if (stack.isEmpty()) continue;
            armor.set(i2, (Object)stack);
        }
    }

    private void handleRenderArm_LowestCanceled(RenderArmEvent event) {
        this.restoreItems((Deque)this.cache.getUnchecked((Object)Minecraft.getInstance().player));
    }

    public void registerEvents() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::handlePreRenderPlayer_High);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, this::handlePostRenderPlayer_Low);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this::handlePreRenderPlayer_LowestCanceled);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::handleRenderHand_High);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this::handleRenderHand_LowestCanceled);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::handleRenderArm_High);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this::handleRenderArm_LowestCanceled);
        NeoForge.EVENT_BUS.addListener(this::handleLoggedOut);
    }

    private void restoreItems(Deque<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                ModObjects.logger.error("Failed in restoring client player items", e);
            }
        }
    }

    static {
        Disabled = false;
    }
}

