/*
 * Decompiled with CFR 0.152.
 */
package com.dynview.Utils;

import com.dynview.ViewDistHandler.ServerDynamicViewDistanceManager;
import net.minecraft.server.MinecraftServer;

public class TickTimeHandler {
    private int meanTickSum = 50;
    private int meanTickCount = 1;
    private int tickTimer = 0;
    public static int serverTickTimerInterval = 100;
    private static TickTimeHandler instance = new TickTimeHandler();
    private int serverMeanTickTime = 50;

    public static TickTimeHandler getInstance() {
        return instance;
    }

    private TickTimeHandler() {
    }

    public void onServerTick(MinecraftServer server) {
        ++this.tickTimer;
        if (this.tickTimer % 20 == 0) {
            this.meanTickSum = (int)((double)this.meanTickSum + (double)TickTimeHandler.average(server.getTickTimesNanos()) * 1.0E-6);
            ++this.meanTickCount;
            if (this.tickTimer >= serverTickTimerInterval) {
                this.serverMeanTickTime = this.meanTickSum / this.meanTickCount;
                this.tickTimer = 0;
                this.meanTickCount = 0;
                this.meanTickSum = 0;
                ServerDynamicViewDistanceManager.getInstance().updateViewDistForMeanTick(this.serverMeanTickTime);
            }
        }
    }

    private static long average(long[] values) {
        if (values == null || values.length == 0) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    public int getMeanTickTime() {
        return this.serverMeanTickTime;
    }
}

