/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.support.resource;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import javax.annotation.Nullable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ResourceContainerFluidHandlerAdapter
implements IFluidHandler {
    private final ResourceContainer container;

    public ResourceContainerFluidHandlerAdapter(ResourceContainer container) {
        this.container = container;
    }

    public int getTanks() {
        return this.container.size();
    }

    public FluidStack getFluidInTank(int tank) {
        ResourceKey resourceKey;
        ResourceAmount resourceAmount = this.container.get(tank);
        if (resourceAmount == null || !((resourceKey = resourceAmount.resource()) instanceof FluidResource)) {
            return FluidStack.EMPTY;
        }
        FluidResource fluidResource = (FluidResource)resourceKey;
        return VariantUtil.toFluidStack(fluidResource, resourceAmount.amount());
    }

    public int getTankCapacity(int tank) {
        PlatformResourceKey resource = this.container.getResource(tank);
        if (resource == null || resource instanceof FluidResource) {
            return (int)ResourceTypes.FLUID.getInterfaceExportLimit();
        }
        return 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return (int)this.container.insert(VariantUtil.ofFluidStack(resource), resource.getAmount(), VariantUtil.toAction(action));
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction action) {
        FluidResource resource = VariantUtil.ofFluidStack(fluidStack);
        long extracted = this.container.extract(resource, fluidStack.getAmount(), VariantUtil.toAction(action));
        if (extracted == 0L) {
            return FluidStack.EMPTY;
        }
        return VariantUtil.toFluidStack(resource, extracted);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidResource resource = this.findExtractableFluidResource();
        if (resource == null) {
            return FluidStack.EMPTY;
        }
        long extracted = this.container.extract(resource, maxDrain, VariantUtil.toAction(action));
        if (extracted == 0L) {
            return FluidStack.EMPTY;
        }
        return VariantUtil.toFluidStack(resource, extracted);
    }

    @Nullable
    private FluidResource findExtractableFluidResource() {
        for (int i = 0; i < this.container.size(); ++i) {
            PlatformResourceKey resource = this.container.getResource(i);
            if (!(resource instanceof FluidResource)) continue;
            FluidResource fluidResource = (FluidResource)resource;
            return fluidResource;
        }
        return null;
    }
}

