/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage;

import com.google.common.collect.AbstractIterator;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public interface CapabilityCache {
    default public Optional<IItemHandler> getItemHandler() {
        return Optional.empty();
    }

    default public Iterator<ResourceKey> getItemIterator() {
        return this.getItemHandler().map(handler -> new AbstractIterator<ResourceKey>(this){
            private int index;

            @Nullable
            protected ResourceKey computeNext() {
                if (this.index > handler.getSlots()) {
                    return (ResourceKey)this.endOfData();
                }
                while (this.index < handler.getSlots()) {
                    ItemStack slot = handler.getStackInSlot(this.index);
                    if (!slot.isEmpty()) {
                        ++this.index;
                        return ItemResource.ofItemStack(slot);
                    }
                    ++this.index;
                }
                return (ResourceKey)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }

    default public Iterator<ResourceAmount> getItemAmountIterator() {
        return this.getItemHandler().map(handler -> new AbstractIterator<ResourceAmount>(this){
            private int index;

            @Nullable
            protected ResourceAmount computeNext() {
                if (this.index > handler.getSlots()) {
                    return (ResourceAmount)this.endOfData();
                }
                while (this.index < handler.getSlots()) {
                    ItemStack slot = handler.getStackInSlot(this.index);
                    if (!slot.isEmpty()) {
                        ++this.index;
                        return new ResourceAmount(ItemResource.ofItemStack(slot), slot.getCount());
                    }
                    ++this.index;
                }
                return (ResourceAmount)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }

    default public Optional<IFluidHandler> getFluidHandler() {
        return Optional.empty();
    }

    default public Iterator<ResourceKey> getFluidIterator() {
        return this.getFluidHandler().map(handler -> new AbstractIterator<ResourceKey>(this){
            private int index;

            @Nullable
            protected ResourceKey computeNext() {
                if (this.index > handler.getTanks()) {
                    return (ResourceKey)this.endOfData();
                }
                while (this.index < handler.getTanks()) {
                    FluidStack slot = handler.getFluidInTank(this.index);
                    if (!slot.isEmpty()) {
                        ++this.index;
                        return VariantUtil.ofFluidStack(slot);
                    }
                    ++this.index;
                }
                return (ResourceKey)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }

    default public Iterator<ResourceAmount> getFluidAmountIterator() {
        return this.getFluidHandler().map(handler -> new AbstractIterator<ResourceAmount>(this){
            private int index;

            @Nullable
            protected ResourceAmount computeNext() {
                if (this.index > handler.getTanks()) {
                    return (ResourceAmount)this.endOfData();
                }
                while (this.index < handler.getTanks()) {
                    FluidStack slot = handler.getFluidInTank(this.index);
                    if (!slot.isEmpty()) {
                        ++this.index;
                        return new ResourceAmount(VariantUtil.ofFluidStack(slot), slot.getAmount());
                    }
                    ++this.index;
                }
                return (ResourceAmount)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }

    public static CapabilityCache ofItemHandler(final IItemHandler itemHandler) {
        return new CapabilityCache(){

            @Override
            public Optional<IItemHandler> getItemHandler() {
                return Optional.of(itemHandler);
            }
        };
    }
}

