/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.grid.strategy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidGridInsertionStrategy
implements GridInsertionStrategy {
    private final AbstractContainerMenu menu;
    private final GridOperations gridOperations;

    public FluidGridInsertionStrategy(AbstractContainerMenu menu, ServerPlayer player, Grid grid) {
        this.menu = menu;
        this.gridOperations = grid.createOperations(ResourceTypes.FLUID, player);
    }

    @Override
    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        IFluidHandlerItem cursorStorage = this.getFluidCursorStorage();
        if (cursorStorage == null) {
            return false;
        }
        FluidStack extractableResource = cursorStorage.getFluidInTank(0);
        if (extractableResource.isEmpty()) {
            return false;
        }
        FluidResource fluidResource = VariantUtil.ofFluidStack(extractableResource);
        this.gridOperations.insert(fluidResource, insertMode, (resource, amount, action, source) -> {
            if (!(resource instanceof FluidResource)) {
                return 0L;
            }
            FluidResource fluidResource2 = (FluidResource)resource;
            FluidStack toDrain = VariantUtil.toFluidStack(fluidResource2, amount == Long.MAX_VALUE ? Integer.MAX_VALUE : amount);
            FluidStack drained = cursorStorage.drain(toDrain, VariantUtil.toFluidAction(action));
            if (action == Action.EXECUTE) {
                this.menu.setCarried(cursorStorage.getContainer());
            }
            return drained.getAmount();
        });
        return true;
    }

    @Nullable
    private IFluidHandlerItem getFluidCursorStorage() {
        return this.getFluidStorage(this.menu.getCarried());
    }

    @Nullable
    private IFluidHandlerItem getFluidStorage(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
    }

    @Override
    public boolean onTransfer(int slotIndex) {
        throw new UnsupportedOperationException();
    }
}

