/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.mojang.serialization.MapCodec;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridOperationsImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

class ItemResourceType
implements ResourceType {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("misc", "resource_type.item");
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("widget/side_button/resource_type/item");

    ItemResourceType() {
    }

    @Override
    public long normalizeAmount(double amount) {
        return (long)amount;
    }

    @Override
    public double getDisplayAmount(long amount) {
        return amount;
    }

    @Override
    public long getInterfaceExportLimit() {
        return 64L;
    }

    @Override
    public GridOperations createGridOperations(RootStorage rootStorage, Actor actor) {
        return new GridOperationsImpl(rootStorage, actor, resource -> {
            long l;
            if (resource instanceof ItemResource) {
                ItemResource itemResource = (ItemResource)resource;
                l = itemResource.item().getDefaultMaxStackSize();
            } else {
                l = 0L;
            }
            return l;
        }, 1L);
    }

    @Override
    public MapCodec<PlatformResourceKey> getMapCodec() {
        return ResourceCodecs.ITEM_MAP_CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, PlatformResourceKey> getStreamCodec() {
        return ResourceCodecs.ITEM_STREAM_CODEC;
    }

    @Override
    public MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    public ResourceLocation getSprite() {
        return SPRITE;
    }

    public String toString() {
        return "ITEM";
    }
}

