/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public record ItemResource(Item item, DataComponentPatch components) implements PlatformResourceKey,
FuzzyModeNormalizer
{
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemResource.class);

    public ItemResource(Item item) {
        this(item, DataComponentPatch.EMPTY);
    }

    public ItemResource(Item item, DataComponentPatch components) {
        this.item = CoreValidations.validateNotNull(item, "Item must not be null");
        this.components = CoreValidations.validateNotNull(components, "Components must not be null");
    }

    public ItemStack toItemStack() {
        return this.toItemStack(1L);
    }

    public ItemStack toItemStack(long amount) {
        if (amount > Integer.MAX_VALUE) {
            LOGGER.warn("Truncating too large amount for {} to fit into ItemStack {}", (Object)this, (Object)amount);
        }
        return new ItemStack(BuiltInRegistries.ITEM.wrapAsHolder((Object)this.item), (int)amount, this.components);
    }

    @Override
    public ResourceKey normalize() {
        return new ItemResource(this.item);
    }

    @Override
    public long getInterfaceExportLimit() {
        return this.item.getDefaultMaxStackSize();
    }

    @Override
    public long getProcessingPatternLimit() {
        return this.item.getDefaultMaxStackSize();
    }

    @Override
    public List<ResourceTag> getTags() {
        return BuiltInRegistries.ITEM.wrapAsHolder((Object)this.item).tags().flatMap(tagKey -> BuiltInRegistries.ITEM.getTag(tagKey).stream()).map(tag -> new ResourceTag(tag.key(), tag.stream().map(holder -> new ItemResource((Item)holder.value())).toList())).toList();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceTypes.ITEM;
    }

    public static ItemResource ofItemStack(ItemStack itemStack) {
        return new ItemResource(itemStack.getItem(), itemStack.getComponentsPatch());
    }
}

