/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainerInsertStrategy;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FluidResourceContainerInsertStrategy
implements ResourceContainerInsertStrategy {
    private static final ItemStack EMPTY_BUCKET = new ItemStack((ItemLike)Items.BUCKET);

    @Override
    public Optional<ResourceContainerInsertStrategy.InsertResult> insert(ItemStack container, ResourceAmount resourceAmount) {
        return Platform.INSTANCE.fillContainer(container, resourceAmount).map(result -> new ResourceContainerInsertStrategy.InsertResult(result.container(), result.amount()));
    }

    @Override
    public Optional<ResourceContainerInsertStrategy.ConversionInfo> getConversionInfo(ResourceKey resource, ItemStack carriedStack) {
        if (!(resource instanceof FluidResource)) {
            return Optional.empty();
        }
        FluidResource fluidResource = (FluidResource)resource;
        ItemStack container = carriedStack.isEmpty() ? EMPTY_BUCKET : carriedStack;
        ResourceAmount toFill = new ResourceAmount(fluidResource, Platform.INSTANCE.getBucketAmount());
        return Platform.INSTANCE.fillContainer(container, toFill).filter(result -> result.amount() > 0L).map(result -> new ResourceContainerInsertStrategy.ConversionInfo(container, result.container()));
    }
}

