/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.core.Direction;

public final class CubeBuilder {
    private CubeBuilder() {
    }

    public static void putCube(PoseStack poseStack, VertexConsumer builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, Direction exclude) {
        poseStack.pushPose();
        for (Direction face : Direction.values()) {
            if (face == exclude) continue;
            CubeBuilder.putFace(poseStack, builder, x1, y1, z1, x2, y2, z2, r, g, b, a, face);
        }
        poseStack.popPose();
    }

    private static void putFace(PoseStack poseStack, VertexConsumer builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, Direction face) {
        switch (face) {
            case DOWN: {
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y1, z1);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y1, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y1, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y1, z1);
                break;
            }
            case UP: {
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y2, z1);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y2, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y2, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y2, z1);
                break;
            }
            case NORTH: {
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y2, z1);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y1, z1);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y1, z1);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y2, z1);
                break;
            }
            case SOUTH: {
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y2, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y1, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y1, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y2, z2);
                break;
            }
            case WEST: {
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y1, z1);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y1, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y2, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x1, y2, z1);
                break;
            }
            case EAST: {
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y2, z1);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y2, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y1, z2);
                CubeBuilder.putVertex(builder, poseStack, r, g, b, a, x2, y1, z1);
            }
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack poseStack, int r, int g, int b, int a, float x, float y, float z) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setColor(r, g, b, a);
    }
}

