/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public final class ResourceSorters {
    private ResourceSorters() {
    }

    public static Comparator<ResourceKey> create(@Nullable RootStorage rootStorage, Inventory playerInventory) {
        return ResourceSorters.create(rootStorage, Collections.emptySet(), playerInventory, Function.identity());
    }

    public static <T> Comparator<T> create(@Nullable RootStorage rootStorage, Set<Pattern> patterns, Inventory playerInventory, Function<T, ResourceKey> resourceExtractor) {
        MutableResourceListImpl available = MutableResourceListImpl.create();
        ResourceSorters.addRootStorageItemsIntoList(rootStorage, available);
        ResourceSorters.addPlayerInventoryItemsIntoList(playerInventory, available);
        ResourceSorters.addPatternOutputsIntoList(patterns, available);
        return ResourceSorters.sortByHighestAvailableFirst(available, resourceExtractor);
    }

    private static void addRootStorageItemsIntoList(@Nullable RootStorage rootStorage, MutableResourceList list) {
        if (rootStorage != null) {
            rootStorage.getAll().forEach(list::add);
        }
    }

    private static void addPlayerInventoryItemsIntoList(Inventory playerInventory, MutableResourceList list) {
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack playerInventoryStack = playerInventory.getItem(i);
            if (playerInventoryStack.isEmpty()) continue;
            list.add(ItemResource.ofItemStack(playerInventoryStack), playerInventoryStack.getCount());
            if (!(playerInventoryStack.getItem() instanceof PatternProviderItem)) continue;
            RefinedStorageApi.INSTANCE.getPattern(playerInventoryStack, playerInventory.player.level()).ifPresent(pattern -> ResourceSorters.addPatternOutputsIntoList(list, pattern));
        }
    }

    private static void addPatternOutputsIntoList(Set<Pattern> patterns, MutableResourceList available) {
        patterns.forEach(pattern -> ResourceSorters.addPatternOutputsIntoList(available, pattern));
    }

    private static void addPatternOutputsIntoList(MutableResourceList available, Pattern pattern) {
        pattern.layout().outputs().forEach(output -> available.add(output.resource(), output.amount()));
    }

    private static <T> Comparator<T> sortByHighestAvailableFirst(ResourceList available, Function<T, ResourceKey> resourceExtractor) {
        return Comparator.comparingLong(obj -> available.get((ResourceKey)resourceExtractor.apply(obj))).reversed();
    }
}

