/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network;

import com.refinedmods.refinedstorage.common.api.support.network.ConnectionSink;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.network.SimpleConnectionStrategy;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ColoredConnectionStrategy
extends SimpleConnectionStrategy {
    protected final Supplier<BlockState> blockStateProvider;

    public ColoredConnectionStrategy(Supplier<BlockState> blockStateProvider, BlockPos origin) {
        super(origin);
        this.blockStateProvider = blockStateProvider;
    }

    @Override
    public void addOutgoingConnections(ConnectionSink sink) {
        Direction myDirection = AbstractDirectionalBlock.tryExtractDirection(this.blockStateProvider.get());
        if (myDirection == null) {
            super.addOutgoingConnections(sink);
            return;
        }
        for (Direction direction : Direction.values()) {
            if (direction == myDirection) continue;
            sink.tryConnectInSameDimension(this.origin.relative(direction), direction.getOpposite());
        }
    }

    @Override
    public boolean canAcceptIncomingConnection(Direction incomingDirection, BlockState connectingState) {
        if (!this.colorsAllowConnecting(connectingState)) {
            return false;
        }
        Direction myDirection = AbstractDirectionalBlock.tryExtractDirection(this.blockStateProvider.get());
        if (myDirection != null) {
            return myDirection != incomingDirection;
        }
        return true;
    }

    protected final boolean colorsAllowConnecting(BlockState connectingState) {
        Block block = connectingState.getBlock();
        if (!(block instanceof ColorableBlock)) {
            return true;
        }
        ColorableBlock otherColorableBlock = (ColorableBlock)block;
        ColorableBlock<?, ?> colorableBlock = this.getColor();
        if (colorableBlock == null) {
            return true;
        }
        return otherColorableBlock.getColor() == colorableBlock.getColor() || colorableBlock.canAlwaysConnect() || otherColorableBlock.canAlwaysConnect();
    }

    @Nullable
    private ColorableBlock<?, ?> getColor() {
        Block block = this.blockStateProvider.get().getBlock();
        if (!(block instanceof ColorableBlock)) {
            return null;
        }
        ColorableBlock colorableBlock = (ColorableBlock)block;
        return colorableBlock;
    }
}

