/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyType;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import net.minecraft.world.inventory.DataSlot;

public class ClientProperty<T>
extends DataSlot
implements Property<T> {
    private final PropertyType<T> type;
    private T value;
    private int rawValue;

    public ClientProperty(PropertyType<T> type, T value) {
        this.type = type;
        this.rawValue = type.serializer().apply(value);
        this.value = value;
    }

    @Override
    public PropertyType<T> getType() {
        return this.type;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public void setValue(T newValue) {
        C2SPackets.sendPropertyChange(this.type, newValue);
    }

    @Override
    public DataSlot getDataSlot() {
        return this;
    }

    public int get() {
        return this.rawValue;
    }

    public void set(int newValue) {
        this.value = this.type.deserializer().apply(newValue);
        this.rawValue = newValue;
        this.onChangedOnClient(this.value);
    }

    protected void onChangedOnClient(T newValue) {
    }
}

