/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.support.Sprites;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButton
extends Button {
    @Nullable
    private Icon icon;

    public IconButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (this.icon != null) {
            graphics.blitSprite(this.icon.sprite, this.getX() + 4, this.getY() + 4, 12, 12);
        }
    }

    protected void renderScrollingString(GuiGraphics graphics, Font font, int width, int color) {
        int offset = this.icon != null ? 6 : 0;
        int start = offset + this.getX() + width;
        int end = offset + this.getX() + this.getWidth() - width;
        IconButton.renderScrollingString((GuiGraphics)graphics, (Font)font, (Component)this.getMessage(), (int)start, (int)this.getY(), (int)end, (int)(this.getY() + this.getHeight()), (int)color);
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
    }

    public static enum Icon {
        ERROR(Sprites.ERROR),
        START(Sprites.START),
        CANCEL(Sprites.CANCEL),
        RESET(Sprites.RESET),
        SET(Sprites.SET);

        private final ResourceLocation sprite;

        private Icon(ResourceLocation sprite) {
            this.sprite = sprite;
        }
    }
}

