/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlockEntity;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class StorageMonitorContainerMenu
extends AbstractResourceContainerMenu {
    private static final Component FILTER_HELP = IdentifierUtil.createTranslation("gui", "storage_monitor.filter_help");

    public StorageMonitorContainerMenu(int syncId, Inventory playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getStorageMonitor(), syncId);
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.addSlots(playerInventory, ResourceContainerImpl.createForFilter(resourceContainerData));
    }

    StorageMonitorContainerMenu(int syncId, Player player, StorageMonitorBlockEntity storageMonitor, ResourceContainer resourceContainer) {
        super(Menus.INSTANCE.getStorageMonitor(), syncId, player);
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, storageMonitor::isFuzzyMode, storageMonitor::setFuzzyMode));
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, storageMonitor::getRedstoneMode, storageMonitor::setRedstoneMode));
        this.addSlots(player.getInventory(), resourceContainer);
    }

    private void addSlots(Inventory playerInventory, ResourceContainer resourceContainer) {
        this.addSlot(new ResourceSlot(resourceContainer, 0, FILTER_HELP, 80, 20, ResourceSlotType.FILTER));
        this.addPlayerInventory(playerInventory, 8, 55);
        this.transferManager.addFilterTransfer((Container)playerInventory);
    }
}

