/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskdrive;

import com.refinedmods.refinedstorage.api.network.impl.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.storage.AbstractDiskContainerBlockEntity;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainerImpl;
import com.refinedmods.refinedstorage.common.storage.diskdrive.DiskDriveContainerMenu;
import com.refinedmods.refinedstorage.common.storage.diskdrive.EmptyStorageDiskInfoAccessor;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractDiskDriveBlockEntity
extends AbstractDiskContainerBlockEntity<StorageNetworkNode> {
    static final int AMOUNT_OF_DISKS = 8;
    private final StorageConfigurationContainerImpl configContainer;

    protected AbstractDiskDriveBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getDiskDrive(), pos, state, new StorageNetworkNode(Platform.INSTANCE.getConfig().getDiskDrive().getEnergyUsage(), Platform.INSTANCE.getConfig().getDiskDrive().getEnergyUsagePerDisk(), 8));
        this.configContainer = new StorageConfigurationContainerImpl(((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration(), this.filter, this::setChanged, this::getRedstoneMode, this::setRedstoneMode);
    }

    @Override
    protected void setFilters(Set<ResourceKey> filters) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilters(filters);
    }

    void setFilterMode(FilterMode mode) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilterMode(mode);
        this.setChanged();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void setAccessMode(AccessMode accessMode) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setAccessMode(accessMode);
    }

    void setVoidExcess(boolean voidExcess) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setVoidExcess(voidExcess);
    }

    @Override
    protected void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setNormalizer(normalizer);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.configContainer.load(tag);
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.configContainer.save(tag);
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.DISK_DRIVE);
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new DiskDriveContainerMenu(syncId, player, this.diskInventory, this.filter.getFilterContainer(), this.configContainer, new EmptyStorageDiskInfoAccessor());
    }
}

