/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AccessModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "access_mode");
    private static final List<MutableComponent> SUBTEXT_INSERT = List.of(IdentifierUtil.createTranslation("gui", "access_mode.insert").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_EXTRACT = List.of(IdentifierUtil.createTranslation("gui", "access_mode.extract").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_INSERT_EXTRACT = List.of(IdentifierUtil.createTranslation("gui", "access_mode.insert_extract").withStyle(ChatFormatting.GRAY));
    private static final Component HELP_INSERT = IdentifierUtil.createTranslation("gui", "access_mode.insert.help");
    private static final Component HELP_EXTRACT = IdentifierUtil.createTranslation("gui", "access_mode.extract.help");
    private static final Component HELP_INSERT_EXTRACT = IdentifierUtil.createTranslation("gui", "access_mode.insert_extract.help");
    private static final ResourceLocation INSERT = IdentifierUtil.createIdentifier("widget/side_button/storage/access_mode/insert");
    private static final ResourceLocation EXTRACT = IdentifierUtil.createIdentifier("widget/side_button/storage/access_mode/extract");
    private static final ResourceLocation INSERT_EXTRACT = IdentifierUtil.createIdentifier("widget/side_button/storage/access_mode/insert_extract");
    private final ClientProperty<AccessMode> property;

    public AccessModeSideButtonWidget(ClientProperty<AccessMode> property) {
        super(AccessModeSideButtonWidget.createPressAction(property));
        this.property = property;
    }

    private static Button.OnPress createPressAction(ClientProperty<AccessMode> property) {
        return btn -> property.setValue(AccessModeSideButtonWidget.toggle((AccessMode)((Object)((Object)property.getValue()))));
    }

    private static AccessMode toggle(AccessMode accessMode) {
        return switch (accessMode) {
            default -> throw new MatchException(null, null);
            case AccessMode.INSERT_EXTRACT -> AccessMode.INSERT;
            case AccessMode.INSERT -> AccessMode.EXTRACT;
            case AccessMode.EXTRACT -> AccessMode.INSERT_EXTRACT;
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case AccessMode.INSERT_EXTRACT -> INSERT_EXTRACT;
            case AccessMode.INSERT -> INSERT;
            case AccessMode.EXTRACT -> EXTRACT;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case AccessMode.INSERT_EXTRACT -> SUBTEXT_INSERT_EXTRACT;
            case AccessMode.INSERT -> SUBTEXT_INSERT;
            case AccessMode.EXTRACT -> SUBTEXT_EXTRACT;
        };
    }

    @Override
    protected Component getHelpText() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case AccessMode.INSERT_EXTRACT -> HELP_INSERT_EXTRACT;
            case AccessMode.INSERT -> HELP_INSERT;
            case AccessMode.EXTRACT -> HELP_EXTRACT;
        };
    }
}

