/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionSink;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.networking.NetworkCardInventory;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverKey;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterContainerMenu;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterData;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterState;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTransmitterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<NetworkTransmitterData>,
BlockEntityWithDrops {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkTransmitterBlockEntity.class);
    private static final NetworkTransmitterData INACTIVE = NetworkTransmitterData.message(false, (Component)IdentifierUtil.createTranslation("gui", "network_transmitter.status.inactive"));
    private static final NetworkTransmitterData MISSING_NETWORK_CARD = NetworkTransmitterData.error((Component)IdentifierUtil.createTranslation("gui", "network_transmitter.status.missing_network_card").withStyle(ChatFormatting.DARK_RED));
    private static final NetworkTransmitterData RECEIVER_UNREACHABLE = NetworkTransmitterData.error((Component)IdentifierUtil.createTranslation("gui", "network_transmitter.status.receiver_unreachable").withStyle(ChatFormatting.DARK_RED));
    private static final String TAG_NETWORK_CARD_INVENTORY = "nc";
    private final NetworkCardInventory networkCardInventory = new NetworkCardInventory();
    private final RateLimiter stateChangeRateLimiter = RateLimiter.create((double)1.0);
    private final RateLimiter networkRebuildRetryRateLimiter = RateLimiter.create((double)0.2);
    @Nullable
    private NetworkReceiverKey receiverKey;

    public NetworkTransmitterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getNetworkTransmitter(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getNetworkTransmitter().getEnergyUsage()));
        this.networkCardInventory.addListener(container -> {
            this.updateReceiverLocation();
            if (this.level != null) {
                LOGGER.debug("Network card was changed at {}, sending network update", (Object)this.worldPosition);
                this.setChanged();
                this.containers.update(this.level);
            }
        });
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(SimpleNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).connectionStrategy(new ColoredConnectionStrategy(() -> ((NetworkTransmitterBlockEntity)this).getBlockState(), this.getBlockPos()){

            @Override
            public void addOutgoingConnections(ConnectionSink sink) {
                super.addOutgoingConnections(sink);
                if (NetworkTransmitterBlockEntity.this.receiverKey != null && ((SimpleNetworkNode)NetworkTransmitterBlockEntity.this.mainNetworkNode).isActive()) {
                    sink.tryConnect(NetworkTransmitterBlockEntity.this.receiverKey.pos());
                }
            }
        }).build();
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        this.containers.update(this.level);
    }

    public void updateStateInLevel(BlockState state) {
        NetworkTransmitterState newState;
        NetworkTransmitterState currentState = (NetworkTransmitterState)((Object)state.getValue(NetworkTransmitterBlock.STATE));
        if (currentState != (newState = this.calculateState()) && this.level != null && this.stateChangeRateLimiter.tryAcquire()) {
            LOGGER.debug("Updating network transmitter at {} from {} to {}", new Object[]{this.worldPosition, currentState, newState});
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue(NetworkTransmitterBlock.STATE, (Comparable)((Object)newState)));
        }
    }

    private NetworkTransmitterState calculateState() {
        if (!((SimpleNetworkNode)this.mainNetworkNode).isActive()) {
            return NetworkTransmitterState.INACTIVE;
        }
        if (this.receiverKey == null) {
            return NetworkTransmitterState.ERROR;
        }
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return NetworkTransmitterState.ERROR;
        }
        boolean receiverFound = NetworkTransmitterBlockEntity.isReceiverFoundInNetwork(network, this.receiverKey);
        return receiverFound ? NetworkTransmitterState.ACTIVE : NetworkTransmitterState.ERROR;
    }

    NetworkTransmitterData getStatus() {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (!((SimpleNetworkNode)this.mainNetworkNode).isActive() || network == null || this.level == null) {
            return INACTIVE;
        }
        if (this.receiverKey == null) {
            return MISSING_NETWORK_CARD;
        }
        boolean receiverFound = NetworkTransmitterBlockEntity.isReceiverFoundInNetwork(network, this.receiverKey);
        if (!receiverFound) {
            return RECEIVER_UNREACHABLE;
        }
        boolean showDistance = this.level.dimension() == this.receiverKey.pos().dimension();
        MutableComponent message = showDistance ? IdentifierUtil.createTranslation("gui", "network_transmitter.status.transmitting", this.receiverKey.getDistance(this.worldPosition)) : this.receiverKey.getDimensionName();
        return NetworkTransmitterData.message(true, (Component)message);
    }

    @Override
    public void doWork() {
        super.doWork();
        if (!((SimpleNetworkNode)this.mainNetworkNode).isActive() || ((SimpleNetworkNode)this.mainNetworkNode).getNetwork() == null || this.receiverKey == null) {
            return;
        }
        boolean receiverFound = NetworkTransmitterBlockEntity.isReceiverFoundInNetwork(((SimpleNetworkNode)this.mainNetworkNode).getNetwork(), this.receiverKey);
        if (!receiverFound && this.networkRebuildRetryRateLimiter.tryAcquire()) {
            this.tryReconnectingWithReceiver();
        }
    }

    private void tryReconnectingWithReceiver() {
        LOGGER.debug("Receiver {} was not found in network for transmitter at {}, retrying and sending network update", (Object)this.receiverKey, (Object)this.worldPosition);
        this.containers.update(this.level);
    }

    private static boolean isReceiverFoundInNetwork(Network network, NetworkReceiverKey key) {
        return network.getComponent(GraphNetworkComponent.class).getContainer(key) != null;
    }

    Container getNetworkCardInventory() {
        return this.networkCardInventory;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_NETWORK_CARD_INVENTORY, (Tag)ContainerUtil.write((Container)this.networkCardInventory, provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(TAG_NETWORK_CARD_INVENTORY)) {
            ContainerUtil.read(tag.getCompound(TAG_NETWORK_CARD_INVENTORY), (Container)this.networkCardInventory, provider);
        }
        this.updateReceiverLocation();
    }

    private void updateReceiverLocation() {
        this.receiverKey = this.networkCardInventory.getReceiverLocation().map(NetworkReceiverKey::new).orElse(null);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new NetworkTransmitterContainerMenu(syncId, inventory, this);
    }

    @Override
    public NetworkTransmitterData getMenuData() {
        return this.getStatus();
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, NetworkTransmitterData> getMenuCodec() {
        return NetworkTransmitterData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.NETWORK_TRANSMITTER);
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{this.networkCardInventory.getNetworkCard()});
    }
}

