/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.security.PlatformSecurityNetworkComponent;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.grid.SecuredGridOperations;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractGridBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<GridNetworkNode>
implements Grid {
    protected AbstractGridBlockEntity(BlockEntityType<? extends AbstractGridBlockEntity> type, BlockPos pos, BlockState state, long energyUsage) {
        super(type, pos, state, new GridNetworkNode(energyUsage));
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(GridNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).priority(Integer.MAX_VALUE).connectionStrategy(new ColoredConnectionStrategy(() -> ((AbstractGridBlockEntity)this).getBlockState(), this.getBlockPos())).build();
    }

    @Override
    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        return Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork()).getComponent(StorageNetworkComponent.class).getResources(actorType);
    }

    @Override
    public Set<PlatformResourceKey> getAutocraftableResources() {
        return Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork()).getComponent(AutocraftingNetworkComponent.class).getOutputs().stream().filter(PlatformResourceKey.class::isInstance).map(PlatformResourceKey.class::cast).collect(Collectors.toSet());
    }

    @Override
    public GridOperations createOperations(ResourceType resourceType, ServerPlayer player) {
        Network network = Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork());
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        PlatformSecurityNetworkComponent security = network.getComponent(PlatformSecurityNetworkComponent.class);
        GridOperations operations = resourceType.createGridOperations(rootStorage, new PlayerActor((Player)player));
        return new SecuredGridOperations(player, security, operations);
    }

    @Override
    public boolean isGridActive() {
        return ((GridNetworkNode)this.mainNetworkNode).isActive();
    }

    @Override
    public Storage getItemStorage() {
        return Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork()).getComponent(StorageNetworkComponent.class);
    }

    @Override
    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType) {
        ((GridNetworkNode)this.mainNetworkNode).addWatcher(watcher, actorType);
    }

    @Override
    public void removeWatcher(GridWatcher watcher) {
        ((GridNetworkNode)this.mainNetworkNode).removeWatcher(watcher);
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount) {
        return Optional.ofNullable(((GridNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getPreview(resource, amount)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource) {
        return Optional.ofNullable(((GridNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getMaxAmount(resource)).orElseGet(() -> CompletableFuture.completedFuture(0L));
    }

    @Override
    public CompletableFuture<Optional<TaskId>> startTask(ResourceKey resource, long amount, Actor actor, boolean notify) {
        Network network = ((GridNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return network.getComponent(AutocraftingNetworkComponent.class).startTask(resource, amount, actor, notify);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

