/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.controller;

import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractEnergyBlockItem;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ControllerBlockItem
extends AbstractEnergyBlockItem {
    private final Block block;

    ControllerBlockItem(Block block) {
        super(block, new Item.Properties().stacksTo(1), RefinedStorageApi.INSTANCE.getEnergyItemHelper());
        this.block = block;
    }

    public Component getDescription() {
        return this.block.getName();
    }

    public Component getName(ItemStack stack) {
        return this.block.getName();
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent((Component)IdentifierUtil.createTranslation("item", "controller.help")));
    }

    public EnergyStorage createEnergyStorage(ItemStack stack) {
        EnergyStorageImpl energyStorage = new EnergyStorageImpl(Platform.INSTANCE.getConfig().getController().getEnergyCapacity());
        return RefinedStorageApi.INSTANCE.asBlockItemEnergyStorage(energyStorage, stack, BlockEntities.INSTANCE.getController());
    }

    protected boolean placeBlock(BlockPlaceContext ctx, BlockState state) {
        ServerPlayer serverPlayer;
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer && !RefinedStorageApi.INSTANCE.canPlaceNetworkNode(serverPlayer = (ServerPlayer)player, ctx.getLevel(), ctx.getClickedPos(), state)) {
            return false;
        }
        return super.placeBlock(ctx, state);
    }
}

