/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusListener;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitor;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorWatcher;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

class WirelessAutocraftingMonitor
implements AutocraftingMonitor {
    private final NetworkItemContext context;

    WirelessAutocraftingMonitor(NetworkItemContext context) {
        this.context = context;
    }

    private Optional<AutocraftingNetworkComponent> getAutocrafting() {
        return this.context.resolveNetwork().map(network -> network.getComponent(AutocraftingNetworkComponent.class));
    }

    @Override
    public void addWatcher(AutocraftingMonitorWatcher watcher) {
        this.context.drainEnergy(Platform.INSTANCE.getConfig().getWirelessAutocraftingMonitor().getOpenEnergyUsage());
    }

    @Override
    public void removeWatcher(AutocraftingMonitorWatcher watcher) {
    }

    @Override
    public boolean isAutocraftingMonitorActive() {
        boolean networkActive = this.context.resolveNetwork().map(network -> network.getComponent(EnergyNetworkComponent.class).getStored() > 0L).orElse(false);
        return networkActive && this.context.isActive();
    }

    @Override
    public List<TaskStatus> getStatuses() {
        return this.getAutocrafting().map(TaskStatusProvider::getStatuses).orElse(Collections.emptyList());
    }

    @Override
    public void addListener(TaskStatusListener listener) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.addListener(listener));
    }

    @Override
    public void removeListener(TaskStatusListener listener) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.removeListener(listener));
    }

    @Override
    public void cancel(TaskId taskId) {
        this.getAutocrafting().ifPresent(autocrafting -> {
            autocrafting.cancel(taskId);
            this.context.drainEnergy(Platform.INSTANCE.getConfig().getWirelessAutocraftingMonitor().getCancelEnergyUsage());
        });
    }

    @Override
    public void cancelAll() {
        this.getAutocrafting().ifPresent(autocrafting -> {
            autocrafting.cancelAll();
            this.context.drainEnergy(Platform.INSTANCE.getConfig().getWirelessAutocraftingMonitor().getCancelAllEnergyUsage());
        });
    }
}

