/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.PatternResolver;
import com.refinedmods.refinedstorage.common.autocrafting.VanillaConstants;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

class StonecutterPatternClientTooltipComponent
implements ClientTooltipComponent {
    private static final int ARROW_SPACING = 8;
    private final Component outputText;
    private final ItemResource input;
    private final ItemResource output;

    StonecutterPatternClientTooltipComponent(PatternResolver.ResolvedStonecutterPattern pattern) {
        this.outputText = StonecutterPatternClientTooltipComponent.getOutputText(pattern.output());
        this.input = pattern.input();
        this.output = pattern.output();
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.drawString(font, this.outputText, x, y, 0xAAAAAA);
        graphics.blitSprite(Sprites.SLOT, x, y + 9 + 2, 18, 18);
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(ItemResource.class);
        rendering.render(this.input, graphics, x + 1, y + 9 + 2 + 1);
        graphics.blitSprite(Sprites.LIGHT_ARROW, x + 18 + 8, y + 9 + 2 + 9 - 7, 22, 15);
        graphics.blitSprite(VanillaConstants.STONECUTTER_RECIPE_SELECTED_SPRITE, x + 18 + 8 + 22 + 8, y + 9 + 2, 16, 18);
        rendering.render(this.output, graphics, x + 18 + 8 + 22 + 8, y + 9 + 2 + 1);
    }

    private static Component getOutputText(ItemResource output) {
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(ItemResource.class);
        return Component.literal((String)"1x ").append(rendering.getDisplayName(output)).withStyle(ChatFormatting.GRAY);
    }

    public int getHeight() {
        return 32;
    }

    public int getWidth(Font font) {
        return Math.max(font.width((FormattedText)this.outputText), 72);
    }
}

